/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.job.JobGroupDto;
import net.ideahut.springboot.job.JobTriggerDto;
import net.ideahut.springboot.job.SchedulerHandler;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MapStringObject;
import org.quartz.SchedulerMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class HelperScheduler {
    private static final Logger log = LoggerFactory.getLogger(HelperScheduler.class);

    private HelperScheduler() {
    }

    protected static Map<String, SchedulerHandler> getHandlers(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                return new LinkedHashMap<String, SchedulerHandler>(applicationContext.getBeansOfType(SchedulerHandler.class));
            }
            catch (Exception e) {
                log.warn("SchedulerHandlers", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected static AdminMenu getMenu(DataMapper dataMapper, Map<String, SchedulerHandler> schedulers, AdminProperties.Module module) {
        if (schedulers != null && !schedulers.isEmpty()) {
            String prefix = "scheduler";
            AdminMenu mroot = new AdminMenu();
            mroot.setId(prefix);
            mroot.setLink("");
            mroot.setTitle("Scheduler");
            if (!HelperMenu.isMenuEnable(mroot, module)) {
                return null;
            }
            String path = new String(mroot.getLink());
            if (path.isEmpty()) {
                path = "/scheduler";
            }
            mroot.setLink("");
            AdminMenu proot = dataMapper.copy((Object)mroot, AdminMenu.class);
            mroot.setChildren(new ArrayList());
            int i = 0;
            for (Map.Entry<String, SchedulerHandler> entry : schedulers.entrySet()) {
                AdminMenu mmenu = new AdminMenu();
                mmenu.setId(prefix + "_" + i);
                mmenu.setLink(path + "?handler=" + entry.getKey());
                mmenu.setTitle(entry.getKey().substring(0, 1).toUpperCase() + entry.getKey().substring(1));
                mmenu.setParent(proot);
                mroot.getChildren().add(mmenu);
                ++i;
            }
            return mroot;
        }
        return null;
    }

    protected static Set<String> packages(Map<String, SchedulerHandler> schedulers, String name) {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        return handler.packages();
    }

    protected static MapStringObject metadata(DataMapper dataMapper, Map<String, SchedulerHandler> schedulers, String name) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        SchedulerMetaData metadata = handler.metadata();
        return dataMapper.convert((Object)metadata, MapStringObject.class);
    }

    protected static boolean start(Map<String, SchedulerHandler> schedulers, String name) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        return handler != null ? handler.start() : false;
    }

    protected static boolean stop(Map<String, SchedulerHandler> schedulers, String name) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        return handler != null ? handler.stop(true) : false;
    }

    protected static boolean running(Map<String, SchedulerHandler> schedulers, String name) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        return handler != null ? handler.running() : false;
    }

    protected static List<JobGroupDto> groups(Map<String, SchedulerHandler> schedulers, String name, Boolean isActive) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.groups(isActive);
        }
        return null;
    }

    protected static List<JobGroupDto> triggers(Map<String, SchedulerHandler> schedulers, String name, Boolean isActive, Collection<String> groupIds) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.triggers(isActive, groupIds);
        }
        return null;
    }

    protected static JobTriggerDto pause(Map<String, SchedulerHandler> schedulers, String name, String triggerId) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.pause(triggerId);
        }
        return null;
    }

    protected static JobTriggerDto resume(Map<String, SchedulerHandler> schedulers, String name, String triggerId) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.resume(triggerId);
        }
        return null;
    }

    protected static JobTriggerDto trigger(Map<String, SchedulerHandler> schedulers, String name, String triggerId) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.trigger(triggerId);
        }
        return null;
    }

    protected static JobTriggerDto delete(Map<String, SchedulerHandler> schedulers, String name, String triggerId) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.delete(triggerId);
        }
        return null;
    }

    protected static JobTriggerDto add(Map<String, SchedulerHandler> schedulers, String name, String triggerId) throws Exception {
        SchedulerHandler handler = HelperScheduler.getHandler(schedulers, name);
        if (handler != null) {
            return handler.add(triggerId);
        }
        return null;
    }

    private static SchedulerHandler getHandler(Map<String, SchedulerHandler> schedulers, String name) {
        if (schedulers != null && !schedulers.isEmpty()) {
            SchedulerHandler handler = schedulers.get(name);
            Assert.notNull((Object)handler, (String)("SchedulerHandler is not found, for: " + name));
            return handler;
        }
        return null;
    }
}

