/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.bean.BeanReload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

final class HelperReload {
    private static final Logger log = LoggerFactory.getLogger(HelperReload.class);

    private HelperReload() {
    }

    protected static Map<String, BeanReload> getBeans(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                return new LinkedHashMap<String, BeanReload>(applicationContext.getBeansOfType(BeanReload.class));
            }
            catch (Exception e) {
                log.warn("BeanReloads", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected static AdminMenu getMenu(Map<String, BeanReload> reloads, AdminProperties.Module module) {
        if (reloads != null && !reloads.isEmpty()) {
            AdminMenu menu = new AdminMenu();
            menu.setId("reload");
            menu.setLink("/reload");
            menu.setTitle("Reload");
            if (HelperMenu.isMenuEnable(menu, module)) {
                return menu;
            }
        }
        return null;
    }
}

