/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.ideahut.springboot.admin.AdminHandlerImpl;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperAudit;
import net.ideahut.springboot.admin.HelperCache;
import net.ideahut.springboot.admin.HelperEntity;
import net.ideahut.springboot.admin.HelperGrid;
import net.ideahut.springboot.admin.HelperRedis;
import net.ideahut.springboot.admin.HelperReload;
import net.ideahut.springboot.admin.HelperScheduler;

final class HelperMenu {
    private HelperMenu() {
    }

    protected static List<AdminMenu> getMenus(AdminHandlerImpl handler) {
        AdminMenu scheduler;
        AdminMenu entity;
        AdminMenu audit;
        AdminMenu grid;
        AdminMenu redis;
        AdminMenu cache;
        ArrayList<AdminMenu> menus = new ArrayList<AdminMenu>();
        AdminProperties.Modules modules = handler.properties.getModules();
        AdminMenu reload = HelperReload.getMenu(handler.reloads, modules.getReload());
        if (reload != null) {
            menus.add(reload);
        }
        if ((cache = HelperCache.getMenu(handler.dataMapper, handler.cacheGroupInfos, handler.cacheSingleInfos, modules.getCache())) != null) {
            menus.add(cache);
        }
        if ((redis = HelperRedis.getMenu(handler.dataMapper, handler.redisInfos, modules.getRedis())) != null) {
            menus.add(redis);
        }
        if ((grid = HelperGrid.getMenu(handler.dataMapper, handler.gridHandler, modules.getGrid())) != null) {
            menus.add(grid);
        }
        if ((audit = HelperAudit.getMenu(handler.dataMapper, handler.auditInfos, modules.getAudit())) != null) {
            menus.add(audit);
        }
        if ((entity = HelperEntity.getMenu(handler.dataMapper, handler.trxManagerInfos, modules.getEntity())) != null) {
            menus.add(entity);
        }
        if ((scheduler = HelperScheduler.getMenu(handler.dataMapper, handler.schedulers, modules.getScheduler())) != null) {
            menus.add(scheduler);
        }
        Collections.sort(menus, Sort.ORDER);
        return menus;
    }

    protected static boolean isMenuEnable(AdminMenu menu, AdminProperties.Module module) {
        menu.setOrder(Integer.valueOf(Integer.MAX_VALUE));
        if (module != null) {
            String path;
            String title;
            String string = title = module.getTitle() != null ? module.getTitle() : "";
            if (!title.trim().isEmpty()) {
                menu.setTitle(title);
            }
            String string2 = path = module.getPath() != null ? module.getPath().trim() : "";
            if (!path.isEmpty() && path.startsWith("/")) {
                menu.setLink(path);
            }
            if (module.getOrder() != null) {
                menu.setOrder(module.getOrder());
            }
            return !Boolean.FALSE.equals(module.getEnable());
        }
        return true;
    }

    protected static final class Sort {
        protected static final Comparator<AdminMenu> TITLE = new Comparator<AdminMenu>(){

            @Override
            public int compare(AdminMenu o1, AdminMenu o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        };
        protected static final Comparator<AdminMenu> ORDER = new Comparator<AdminMenu>(){

            @Override
            public int compare(AdminMenu o1, AdminMenu o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };

        protected Sort() {
        }
    }
}

