/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.admin.HelperObject;
import net.ideahut.springboot.cache.CacheGroupHandler;
import net.ideahut.springboot.cache.CacheHandler;
import net.ideahut.springboot.cache.CacheInfo;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class HelperCache {
    private static final Logger log = LoggerFactory.getLogger(HelperCache.class);

    private HelperCache() {
    }

    protected static Map<String, HelperObject.AdminCacheInfo> getGroupInfos(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                TreeMap<String, HelperObject.AdminCacheInfo> adinfos = new TreeMap<String, HelperObject.AdminCacheInfo>();
                Map groups = applicationContext.getBeansOfType(CacheGroupHandler.class);
                for (Map.Entry entry : groups.entrySet()) {
                    CacheInfo info = ((CacheGroupHandler)entry.getValue()).info();
                    if (info == null) continue;
                    info.setName((String)entry.getKey());
                    info.setLabel(((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1));
                    HelperObject.AdminCacheInfo adinfo = new HelperObject.AdminCacheInfo();
                    adinfo.setInfo(info);
                    adinfo.setHandler(entry.getValue());
                    adinfos.put(info.getName(), adinfo);
                }
                return Collections.unmodifiableMap(adinfos);
            }
            catch (Exception e) {
                log.warn("CacheGroupInfos", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected static Map<String, HelperObject.AdminCacheInfo> getSingleInfos(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                TreeMap<String, HelperObject.AdminCacheInfo> adinfos = new TreeMap<String, HelperObject.AdminCacheInfo>();
                Map singles = applicationContext.getBeansOfType(CacheHandler.class);
                for (Map.Entry entry : singles.entrySet()) {
                    CacheInfo info = ((CacheHandler)entry.getValue()).info();
                    if (info == null) continue;
                    info.setName((String)entry.getKey());
                    info.setLabel(((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1));
                    HelperObject.AdminCacheInfo adinfo = new HelperObject.AdminCacheInfo();
                    adinfo.setInfo(info);
                    adinfo.setHandler(entry.getValue());
                    adinfos.put(info.getName(), adinfo);
                }
                return Collections.unmodifiableMap(adinfos);
            }
            catch (Exception e) {
                log.warn("CacheSingleInfos", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected static AdminMenu getMenu(DataMapper dataMapper, Map<String, HelperObject.AdminCacheInfo> groupInfos, Map<String, HelperObject.AdminCacheInfo> singleInfos, AdminProperties.Module module) {
        String prefix;
        AdminMenu mroot = new AdminMenu();
        mroot.setId("cache");
        mroot.setLink("");
        mroot.setTitle("Cache");
        if (!HelperMenu.isMenuEnable(mroot, module)) {
            return null;
        }
        String path = new String(mroot.getLink());
        if (path.isEmpty()) {
            path = "/cache";
        }
        mroot.setLink("");
        AdminMenu proot = dataMapper.copy((Object)mroot, AdminMenu.class);
        mroot.setChildren(new ArrayList());
        if (groupInfos != null && !groupInfos.isEmpty()) {
            prefix = "cache_group";
            AdminMenu mgroup = new AdminMenu();
            mgroup.setId(prefix);
            mgroup.setLink("");
            mgroup.setTitle("Group");
            mgroup.setParent(proot);
            AdminMenu pgroup = dataMapper.copy((Object)mgroup, AdminMenu.class);
            mgroup.setChildren(new ArrayList());
            int i = 0;
            for (Map.Entry<String, HelperObject.AdminCacheInfo> entry : groupInfos.entrySet()) {
                AdminMenu mcache = new AdminMenu();
                mcache.setId(prefix + "_" + i);
                mcache.setLink(path + "?type=group&handler=" + entry.getKey());
                mcache.setTitle(entry.getKey().substring(0, 1).toUpperCase() + entry.getKey().substring(1));
                mcache.setParent(pgroup);
                mgroup.getChildren().add(mcache);
            }
            Collections.sort(mgroup.getChildren(), HelperMenu.Sort.TITLE);
            mroot.getChildren().add(mgroup);
        }
        if (singleInfos != null && !singleInfos.isEmpty()) {
            prefix = "cache_single";
            AdminMenu msingle = new AdminMenu();
            msingle.setId(prefix);
            msingle.setLink(path + "?type=single&handler=_");
            msingle.setTitle("Single");
            msingle.setParent(proot);
            mroot.getChildren().add(msingle);
        }
        return !mroot.getChildren().isEmpty() ? mroot : null;
    }

    protected static List<CacheInfo> infos(Map<String, HelperObject.AdminCacheInfo> cacheInfos) {
        if (cacheInfos != null) {
            ArrayList<CacheInfo> infos = new ArrayList<CacheInfo>();
            for (HelperObject.AdminCacheInfo adinfo : cacheInfos.values()) {
                infos.add(adinfo.getInfo());
            }
            return infos;
        }
        return null;
    }

    protected static Page keys(Map<String, HelperObject.AdminCacheInfo> groupInfos, Map<String, HelperObject.AdminCacheInfo> singleInfos, CacheInfo input, Integer index, Integer size) {
        List keys;
        Assert.notNull((Object)input, (String)"CacheInfo is required");
        Assert.hasLength((String)input.getName(), (String)"CacheInfo name is required");
        index = index != null && index > 0 ? index : 1;
        size = size != null && size > 0 ? size : 20;
        Page page = Page.of((Integer)index, (Integer)size);
        if (input.getGroup() != null) {
            info = groupInfos != null ? groupInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            handler = (CacheGroupHandler)info.getHandler();
            keys = handler.keys(input.getGroup());
        } else {
            info = singleInfos != null ? singleInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            handler = (CacheHandler)info.getHandler();
            keys = handler.keys();
        }
        if (keys != null && !keys.isEmpty()) {
            int max;
            int min = (index - 1) * size;
            if (min > keys.size() - 1) {
                if (index > 1) {
                    index = index - 1;
                }
                min = (index - 1) * size;
                page.setIndex(index);
            }
            if ((max = min + size) > keys.size()) {
                max = keys.size();
            }
            page.setRecords(Long.valueOf(keys.size()));
            page.setData(keys.subList(min, max));
        }
        return page;
    }

    protected static void delete(Map<String, HelperObject.AdminCacheInfo> groupInfos, Map<String, HelperObject.AdminCacheInfo> singleInfos, CacheInfo input, Collection<String> keys) {
        Assert.notNull((Object)input, (String)"CacheInfo is required");
        Assert.hasLength((String)input.getName(), (String)"CacheInfo name is required");
        if (input.getGroup() != null) {
            HelperObject.AdminCacheInfo info = groupInfos != null ? groupInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            CacheGroupHandler handler = (CacheGroupHandler)info.getHandler();
            handler.multiDel(input.getGroup(), keys);
        } else {
            HelperObject.AdminCacheInfo info = singleInfos != null ? singleInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            CacheHandler handler = (CacheHandler)info.getHandler();
            handler.multiDel(keys);
        }
    }

    protected static void clear(Map<String, HelperObject.AdminCacheInfo> groupInfos, Map<String, HelperObject.AdminCacheInfo> singleInfos, CacheInfo input) {
        Assert.notNull((Object)input, (String)"CacheInfo is required");
        Assert.hasLength((String)input.getName(), (String)"CacheInfo name is required");
        if (input.getGroup() != null) {
            HelperObject.AdminCacheInfo info = groupInfos != null ? groupInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            CacheGroupHandler handler = (CacheGroupHandler)info.getHandler();
            handler.clear(input.getGroup());
        } else {
            HelperObject.AdminCacheInfo info = singleInfos != null ? singleInfos.get(input.getName()) : null;
            Assert.notNull((Object)info, (String)"CacheInfo is not found");
            CacheHandler handler = (CacheHandler)info.getHandler();
            handler.clear();
        }
    }
}

