/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.admin.HelperObject;
import net.ideahut.springboot.audit.AuditAccessible;
import net.ideahut.springboot.audit.AuditHandler;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class HelperAudit {
    private static final Logger log = LoggerFactory.getLogger(HelperAudit.class);

    private HelperAudit() {
    }

    protected static Map<String, HelperObject.AdminAuditInfo> getInfos(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                TreeMap<String, HelperObject.AdminAuditInfo> infos = new TreeMap<String, HelperObject.AdminAuditInfo>();
                Map handlers = applicationContext.getBeansOfType(AuditHandler.class);
                for (Map.Entry entry : handlers.entrySet()) {
                    HelperObject.AdminAuditInfo info = new HelperObject.AdminAuditInfo();
                    info.setAuditAccessible(((AuditHandler)entry.getValue()).getAccessibles());
                    info.setHandler((AuditHandler)entry.getValue());
                    infos.put((String)entry.getKey(), info);
                }
                return Collections.unmodifiableMap(infos);
            }
            catch (Exception e) {
                log.warn("AuditInfos", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected static AdminMenu getMenu(DataMapper dataMapper, Map<String, HelperObject.AdminAuditInfo> auditInfos, AdminProperties.Module module) {
        if (auditInfos != null && !auditInfos.isEmpty()) {
            String prefix = "audit";
            AdminMenu mroot = new AdminMenu();
            mroot.setId(prefix);
            mroot.setLink("");
            mroot.setTitle("Audit");
            if (!HelperMenu.isMenuEnable(mroot, module)) {
                return null;
            }
            String path = new String(mroot.getLink());
            if (path.isEmpty()) {
                path = "/audit";
            }
            mroot.setLink("");
            AdminMenu proot = dataMapper.copy((Object)mroot, AdminMenu.class);
            mroot.setChildren(new ArrayList());
            for (Map.Entry<String, HelperObject.AdminAuditInfo> entryInfo : auditInfos.entrySet()) {
                String titleInfo = entryInfo.getKey().substring(0, 1).toUpperCase() + entryInfo.getKey().substring(1);
                HelperObject.AdminAuditInfo info = entryInfo.getValue();
                Map<String, AuditAccessible> accessible = info.getAuditAccessible();
                int i = 0;
                for (Map.Entry<String, AuditAccessible> entryAccessible : accessible.entrySet()) {
                    String titleMenu = entryAccessible.getKey().substring(0, 1).toUpperCase() + entryAccessible.getKey().substring(1);
                    titleMenu = titleMenu + " (" + titleInfo + ")";
                    AdminMenu mmenu = new AdminMenu();
                    mmenu.setId(prefix + "_" + i);
                    mmenu.setLink("");
                    mmenu.setTitle(titleMenu);
                    mmenu.setParent(proot);
                    Map members = entryAccessible.getValue().getMembers();
                    if (members != null && !members.isEmpty()) {
                        AdminMenu pmenu = dataMapper.copy((Object)mmenu, AdminMenu.class);
                        mmenu.setChildren(new ArrayList());
                        ArrayList<AdminMenu> children = new ArrayList<AdminMenu>();
                        int j = 1;
                        boolean hasVoid = false;
                        for (AuditAccessible.AuditMember member : members.values()) {
                            if (!Void.class.equals((Object)member.getType())) {
                                AdminMenu mchild = new AdminMenu();
                                mchild.setId(prefix + "_" + i + "_" + j);
                                mchild.setLink(path + "?handler=" + entryInfo.getKey() + "&type=" + member.getType().getName() + "&manager=" + entryAccessible.getKey());
                                mchild.setTitle(member.getType().getSimpleName());
                                mchild.setParent(pmenu);
                                children.add(mchild);
                                ++j;
                                continue;
                            }
                            hasVoid = true;
                        }
                        Collections.sort(children, HelperMenu.Sort.TITLE);
                        if (hasVoid) {
                            AdminMenu mchild0 = new AdminMenu();
                            mchild0.setId(prefix + "_" + i + "_0");
                            mchild0.setLink(path + "?handler=" + entryInfo.getKey() + "&type=_&manager=" + entryAccessible.getKey());
                            mchild0.setTitle(entryAccessible.getValue().getIdentifier());
                            mchild0.setParent(pmenu);
                            mmenu.getChildren().add(mchild0);
                        }
                        mmenu.getChildren().addAll(children);
                    } else {
                        mmenu.setLink(path + "?handler=" + entryInfo.getKey() + "&type=_&manager=" + entryAccessible.getKey());
                    }
                    mroot.getChildren().add(mmenu);
                }
            }
            return mroot;
        }
        return null;
    }

    protected static AuditAccessible.AuditMember info(Map<String, HelperObject.AdminAuditInfo> auditInfos, String handler, String manager, String type) {
        Assert.notNull(auditInfos, (String)"Module audit unsupported");
        HelperObject.AdminAuditInfo info = auditInfos.get(handler);
        Assert.notNull((Object)info, (String)("Audit handler is not found: " + handler));
        AuditAccessible accessible = info.getAuditAccessible().get(manager);
        Assert.notNull((Object)accessible, (String)("Audit Accessible is not found, handler: " + handler + ", manager: " + manager));
        if (type != null && !"_".equals(type) && !"".equals(type)) {
            Class clazz = FrameworkUtil.classOf(type);
            AuditAccessible.AuditMember member = accessible.getMembers() != null ? (AuditAccessible.AuditMember)accessible.getMembers().get(clazz) : null;
            Assert.notNull((Object)info, (String)("Audit Type is not found, handler: " + handler + ", manager: " + manager + ", type: " + type));
            return member;
        }
        return null;
    }

    protected static Page list(Map<String, HelperObject.AdminAuditInfo> auditInfos, String handler, byte[] data) {
        String entity;
        Assert.notNull(auditInfos, (String)"Module audit unsupported");
        HelperObject.AdminAuditInfo info = auditInfos.get(handler);
        Assert.notNull((Object)info, (String)("Audit handler is not found: " + handler));
        AuditRequest request = info.getHandler().getRequest(data);
        String string = entity = request.getEntity() != null ? request.getEntity().trim() : "";
        if (!entity.isEmpty()) {
            request.setClassOfEntity(FrameworkUtil.classOf(entity));
        }
        return info.getHandler().getList(request);
    }
}

