/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import net.ideahut.springboot.IdeahutVersion;
import net.ideahut.springboot.admin.AdminHandler;
import net.ideahut.springboot.admin.AdminInfo;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.grid.GridAdditional;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridHandlerImpl;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.StringUtil;
import org.hibernate.Version;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

final class HelperAdmin {
    private HelperAdmin() {
    }

    protected static AdminInfo getInfo(ApplicationContext applicationContext) {
        AdminInfo.Application application = new AdminInfo.Application();
        application.setApplicationName(applicationContext.getApplicationName());
        application.setBeanCount(Integer.valueOf(applicationContext.getBeanDefinitionCount()));
        application.setDisplayName(applicationContext.getDisplayName());
        application.setId(applicationContext.getId());
        application.setStartupDate(Long.valueOf(applicationContext.getStartupDate()));
        WebServer webServer = FrameworkUtil.getWebServer(applicationContext);
        if (webServer != null) {
            application.setServerClassname(webServer.getClass().getName());
            application.setServerPort(Integer.valueOf(webServer.getPort()));
        }
        AdminInfo.Version version = new AdminInfo.Version();
        version.setReactive(Boolean.valueOf(FrameworkUtil.isReactiveApplication(applicationContext)));
        version.setHibernate(Version.getVersionString());
        version.setIdeahut(IdeahutVersion.getVersion());
        version.setJava(System.getProperty("java.version"));
        version.setSpringBoot(SpringBootVersion.getVersion());
        version.setSpringFramework(SpringVersion.getVersion());
        ArrayList<AdminInfo.Bean> beans = new ArrayList<AdminInfo.Bean>();
        for (String name : applicationContext.getBeanDefinitionNames()) {
            Object object = applicationContext.getBean(name);
            AdminInfo.Bean bean = new AdminInfo.Bean();
            bean.setBeanName(name);
            bean.setClassName(object.getClass().getName());
            bean.setIsProxy(Boolean.valueOf(Proxy.isProxyClass(object.getClass())));
            bean.setIsReconfigure(Boolean.valueOf(object instanceof BeanConfigure));
            bean.setIsReloadable(Boolean.valueOf(object instanceof BeanReload));
            beans.add(bean);
        }
        AdminInfo info = new AdminInfo();
        info.setApplication(application);
        info.setBeans(beans);
        info.setVersion(version);
        return info;
    }

    protected static void checkProperties(AdminProperties properties) {
        String redirectParameter;
        AdminProperties.Grid grid = properties.getGrid();
        if (grid != null && !Boolean.FALSE.equals(grid.getEnable())) {
            Assert.hasLength((String)grid.getLocation(), (String)"properties.grid.location is required");
        }
        grid.setLocation(FrameworkUtil.replacePath(grid.getLocation()));
        AdminProperties.Resource resource = properties.getResource();
        Assert.notNull((Object)resource, (String)"properties.resource is required");
        Assert.hasLength((String)resource.getLocations(), (String)"properties.resource.locations is required");
        resource.setLocations(FrameworkUtil.replacePath(resource.getLocations()));
        Assert.hasLength((String)resource.getRequestPath(), (String)"properties.resource.requestPath is required");
        Assert.hasLength((String)resource.getIndexFile(), (String)"properties.resource.indexFile is required");
        if (resource.getAllowedPaths() == null) {
            resource.setAllowedPaths(new HashSet());
        }
        if (resource.getAlwaysToIndex() == null) {
            resource.setAlwaysToIndex(Boolean.TRUE);
        }
        String string = redirectParameter = (redirectParameter = resource.getRedirectParameter()) != null ? redirectParameter.trim() : "";
        if (redirectParameter.isEmpty()) {
            redirectParameter = "_next_";
        }
        resource.setRedirectParameter(redirectParameter);
        resource.setRequestPath(StringUtil.removeEnd((String)resource.getRequestPath(), (String)"/"));
        HashSet<String> allowedPaths = new HashSet<String>();
        if (resource.getAllowedPaths() != null) {
            for (String allowedPath : resource.getAllowedPaths()) {
                String path = StringUtil.removeEnd((String)allowedPath, (String)"/");
                path = StringUtil.removeStart((String)path, (String)"/");
                allowedPaths.add(path);
            }
        }
        allowedPaths.add(resource.getIndexFile());
        resource.setAllowedPaths(allowedPaths);
        AdminProperties.Api api = properties.getApi();
        Assert.notNull((Object)api, (String)"properties.api is required");
        Assert.hasLength((String)api.getRequestPath(), (String)"properties.api.requestPath is required");
        api.setRequestPath(StringUtil.removeEnd((String)api.getRequestPath(), (String)"/"));
        String loginPath = api.getLoginPath();
        String string2 = loginPath = loginPath != null ? loginPath.trim() : "";
        if (loginPath.isEmpty()) {
            loginPath = "/login";
        }
        api.setLoginPath(StringUtil.removeEnd((String)loginPath, (String)"/"));
        String logoutPath = api.getLogoutPath();
        String string3 = logoutPath = logoutPath != null ? logoutPath.trim() : "";
        if (logoutPath.isEmpty()) {
            logoutPath = "/logout";
        }
        api.setLogoutPath(logoutPath);
        String infoHeader = api.getInfoHeader();
        String string4 = infoHeader = infoHeader != null ? infoHeader.trim() : "";
        if (infoHeader.isEmpty()) {
            infoHeader = "Admin-Info";
        }
        api.setInfoHeader(infoHeader);
        if (properties.getModules() == null) {
            properties.setModules(new AdminProperties.Modules());
        }
    }

    protected static String getRedirect(String path, String query, AdminProperties.Resource resource) {
        Object servletPath = path != null ? new String(path) : "";
        String requestPath = resource.getRequestPath() + "/";
        if (((String)servletPath).length() < requestPath.length() && !((String)servletPath).endsWith("/")) {
            servletPath = (String)servletPath + "/";
        }
        if (((String)servletPath).startsWith(requestPath)) {
            Object queryString = query != null ? "?" + query : "";
            String nextPath = ((String)servletPath).substring(requestPath.length());
            if (nextPath.isEmpty()) {
                return requestPath + resource.getIndexFile() + (String)queryString;
            }
            int idx = nextPath.indexOf("/");
            if (idx != -1) {
                nextPath = nextPath.substring(0, idx);
            }
            if (!resource.getAllowedPaths().contains(nextPath) && Boolean.TRUE.equals(resource.getAlwaysToIndex())) {
                Object redirect = "/" + nextPath + (String)queryString;
                redirect = Base64.getEncoder().encodeToString(((String)redirect).getBytes());
                try {
                    redirect = URLEncoder.encode((String)redirect, StandardCharsets.UTF_8.name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return requestPath + resource.getIndexFile() + "?" + resource.getRedirectParameter() + "=" + (String)redirect;
            }
        }
        return null;
    }

    protected static GridHandler getGridHandler(ApplicationContext applicationContext, DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, String location, Map<String, GridOption> options, Map<String, GridAdditional> additionals) throws Exception {
        String string = location = location != null ? location.trim() : "";
        if (!location.isEmpty()) {
            GridHandlerImpl gridHandler = new GridHandlerImpl().setApplicationContext(applicationContext).setDataMapper(dataMapper).setLocation(location).setRedisTemplate(redisTemplate).setAdditionals(additionals).setOptions(options).setPrefix(AdminHandler.class.getSimpleName());
            gridHandler.afterPropertiesSet();
            return gridHandler;
        }
        return null;
    }
}

