/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.TimeoutUtils;

final class DepreHelper {
    private DepreHelper() {
    }

    protected static Properties redisInfo(RedisConnection connection) {
        return connection.info();
    }

    protected static Boolean redisExpire(RedisConnection connection, byte[] key, TimeUnit unit, Long timeout) {
        try {
            return connection.pExpire(key, TimeoutUtils.toMillis((long)timeout, (TimeUnit)unit));
        }
        catch (Exception ignore) {
            return connection.expire(key, TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit));
        }
    }

    protected static Boolean redisSet(RedisConnection connection, byte[] key, byte[] value) {
        return connection.set(key, value);
    }

    protected static byte[] redisGet(RedisConnection connection, byte[] key) {
        return connection.get(key);
    }

    protected static void redisFlushDb(RedisConnection connection) {
        connection.flushDb();
    }

    protected static void redisFlushAll(RedisConnection connection) {
        connection.flushAll();
    }
}

