/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.security.SecurityAuthorization;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.RequestUtil;
import net.ideahut.springboot.util.StringUtil;
import net.ideahut.springboot.util.WebUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AdminSecurity
implements SecurityAuthorization,
InitializingBean {
    private SecurityCredential credential;
    private AdminProperties properties;
    private DataMapper dataMapper;
    private String headerKey;
    private Boolean enableRemoteHost;
    private Boolean enableUserAgent;

    public AdminSecurity setCredential(SecurityCredential credential) {
        this.credential = credential;
        return this;
    }

    public AdminSecurity setProperties(AdminProperties properties) {
        this.properties = properties;
        return this;
    }

    public AdminSecurity setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public AdminSecurity setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
        return this;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public AdminSecurity setEnableRemoteHost(Boolean enableRemoteHost) {
        this.enableRemoteHost = enableRemoteHost;
        return this;
    }

    public AdminSecurity setEnableUserAgent(Boolean enableUserAgent) {
        this.enableUserAgent = enableUserAgent;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.credential, (String)"credential is required");
        Assert.notNull((Object)this.properties, (String)"properties is required");
        String string = this.headerKey = this.headerKey != null ? this.headerKey.trim() : "";
        if (this.headerKey.isEmpty()) {
            this.headerKey = "Authorization";
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.enableRemoteHost == null) {
            this.enableRemoteHost = Boolean.FALSE;
        }
        if (this.enableUserAgent == null) {
            this.enableUserAgent = Boolean.FALSE;
        }
    }

    public boolean isRequestAuthorized(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String agent;
        String host;
        AdminProperties.Resource resource = this.properties.getResource();
        String resourcePath = resource.getRequestPath();
        String servletPath = request.getServletPath();
        if (servletPath.startsWith(resourcePath)) {
            return true;
        }
        AdminProperties.Api api = this.properties.getApi();
        String infoStr = RequestUtil.getHeader((HttpServletRequest)request, (String)api.getInfoHeader());
        boolean isInfo = (Boolean)StringUtil.valueOf(Boolean.TYPE, (String)infoStr, (Object)false);
        if (isInfo) {
            return this.info(request, response);
        }
        String loginPath = api.getRequestPath() + api.getLoginPath();
        if (servletPath.startsWith(loginPath) && "POST".equalsIgnoreCase(request.getMethod())) {
            return this.login(request, response);
        }
        String authorization = RequestUtil.getHeader((HttpServletRequest)request, (String)this.headerKey, (String)"").trim();
        if (authorization.isEmpty()) {
            return this.notAuthorized(response);
        }
        String remoteHost = RequestUtil.getRemoteHost((HttpServletRequest)request);
        String userAgent = RequestUtil.getUserAgent((HttpServletRequest)request);
        MapStringObject parameter = new MapStringObject();
        parameter.put("authorization", (Object)authorization);
        parameter.put("host", (Object)remoteHost);
        parameter.put("agent", (Object)userAgent);
        if (!this.credential.isValidCredential(parameter)) {
            return this.notAuthorized(response);
        }
        SecurityUser user = this.credential.getSecurityUser(parameter);
        if (Boolean.TRUE.equals(this.enableRemoteHost) && !(host = (String)user.getAttribute(String.class, SecurityUser.Attribute.HOST, (Object)"")).equals(remoteHost)) {
            return this.notAuthorized(response);
        }
        if (Boolean.TRUE.equals(this.enableUserAgent) && !(agent = (String)user.getAttribute(String.class, SecurityUser.Attribute.AGENT, (Object)"")).equals(userAgent)) {
            return this.notAuthorized(response);
        }
        String logoutPath = api.getRequestPath() + api.getLogoutPath();
        if (servletPath.startsWith(logoutPath)) {
            return this.logout(parameter);
        }
        return true;
    }

    private boolean info(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Cookie[] rqCookies;
        Enumeration enParameters;
        MapStringObject info = new MapStringObject();
        info.put("CharacterEncoding", (Object)request.getCharacterEncoding());
        info.put("ContentType", (Object)request.getContentType());
        info.put("ContentLength", (Object)request.getContentLengthLong());
        info.put("ContextPath", (Object)request.getContextPath());
        info.put("Locale", (Object)request.getLocale().toString());
        info.put("Method", (Object)request.getMethod());
        info.put("PathInfo", (Object)request.getPathInfo());
        info.put("PathTranslated", (Object)request.getPathTranslated());
        info.put("Protocol", (Object)request.getProtocol());
        info.put("ProtocolRequestId", (Object)request.getProtocolRequestId());
        info.put("QueryString", (Object)request.getQueryString());
        info.put("RemoteAddr", (Object)request.getRemoteAddr());
        info.put("RemoteHost", (Object)request.getRemoteHost());
        info.put("RemotePort", (Object)request.getRemotePort());
        info.put("RemoteUser", (Object)request.getRemoteUser());
        info.put("RequestId", (Object)request.getRequestId());
        info.put("RequestURI", (Object)request.getRequestURI());
        info.put("RequestedSessionId", (Object)request.getRequestedSessionId());
        info.put("Scheme", (Object)request.getScheme());
        info.put("ServletPath", (Object)request.getServletPath());
        Enumeration enHeaders = request.getHeaderNames();
        if (enHeaders != null) {
            MapStringObject headers = new MapStringObject();
            while (enHeaders.hasMoreElements()) {
                String name;
                Enumeration values = request.getHeaders(name = (String)enHeaders.nextElement());
                headers.put(name, values != null ? Collections.list(values) : null);
            }
            info.put("Headers", (Object)headers);
        }
        if ((enParameters = request.getParameterNames()) != null) {
            MapStringObject parameters = new MapStringObject();
            while (enParameters.hasMoreElements()) {
                String name = (String)enParameters.nextElement();
                String[] values = request.getParameterValues(name);
                parameters.put(name, (Object)values);
            }
            info.put("Parameters", (Object)parameters);
        }
        if ((rqCookies = request.getCookies()) != null) {
            ArrayList cookies = new ArrayList();
            for (Cookie rqCookie : rqCookies) {
                MapStringObject cookie = new MapStringObject();
                cookie.put("Domain", (Object)rqCookie.getDomain());
                cookie.put("MaxAge", (Object)rqCookie.getMaxAge());
                cookie.put("Name", (Object)rqCookie.getName());
                cookie.put("Path", (Object)rqCookie.getPath());
                cookie.put("Secure", (Object)rqCookie.getSecure());
                cookie.put("Value", (Object)rqCookie.getValue());
            }
            info.put("Cookies", cookies);
        }
        return this.sendResult(request, response, Result.success((Object)info));
    }

    private boolean login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String username = request.getParameter("username");
        if (username == null || username.isEmpty()) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-01", (String)"username is required"));
        }
        String password = request.getParameter("password");
        if (password == null || password.isEmpty()) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-02", (String)"password is required"));
        }
        String authorization = UUID.randomUUID().toString();
        MapStringObject parameter = new MapStringObject();
        parameter.put("username", (Object)username);
        parameter.put("password", (Object)password);
        parameter.put("authorization", (Object)authorization);
        parameter.put("host", (Object)RequestUtil.getRemoteHost((HttpServletRequest)request));
        parameter.put("agent", (Object)RequestUtil.getUserAgent((HttpServletRequest)request));
        if (!this.credential.registerUser(parameter)) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-03", (String)"Invalid user"));
        }
        return this.sendResult(request, response, Result.success((Object)authorization));
    }

    private boolean logout(MapStringObject parameter) throws Exception {
        this.credential.invalidate(parameter);
        return false;
    }

    private boolean notAuthorized(HttpServletResponse response) throws Exception {
        response.sendError(401);
        return false;
    }

    private boolean sendResult(HttpServletRequest request, HttpServletResponse response, Result result) throws Exception {
        WebUtil.sendToClient(this.dataMapper, request, response, result);
        return false;
    }
}

