/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import com.esri.core.geometry.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.iakovlev.timeshape.Index;
import net.iakovlev.timeshape.SameZoneSpan;
import net.iakovlev.timeshape.proto.Geojson;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeZoneEngine
implements Serializable {
    private final Index index;
    private static final double MIN_LAT = -90.0;
    private static final double MIN_LON = -180.0;
    private static final double MAX_LAT = 90.0;
    private static final double MAX_LON = 180.0;
    private static final Logger log = LoggerFactory.getLogger(TimeZoneEngine.class);

    private TimeZoneEngine(Index index) {
        this.index = index;
    }

    private static void validateCoordinates(double minLat, double minLon, double maxLat, double maxLon) {
        ArrayList<String> errors = new ArrayList<String>();
        if (minLat < -90.0 || minLat > 90.0) {
            errors.add(String.format(Locale.ROOT, "minimum latitude %f is out of range: must be -90 <= latitude <= 90;", minLat));
        }
        if (maxLat < -90.0 || maxLat > 90.0) {
            errors.add(String.format(Locale.ROOT, "maximum latitude %f is out of range: must be -90 <= latitude <= 90;", maxLat));
        }
        if (minLon < -180.0 || minLon > 180.0) {
            errors.add(String.format(Locale.ROOT, "minimum longitude %f is out of range: must be -180 <= longitude <= 180;", minLon));
        }
        if (maxLon < -180.0 || maxLon > 180.0) {
            errors.add(String.format(Locale.ROOT, "maximum longitude %f is out of range: must be -180 <= longitude <= 180;", maxLon));
        }
        if (minLat > maxLat) {
            errors.add(String.format(Locale.ROOT, "maximum latitude %f is less than minimum latitude %f;", maxLat, minLat));
        }
        if (minLon > maxLon) {
            errors.add(String.format(Locale.ROOT, "maximum longitude %f is less than minimum longitude %f;", maxLon, minLon));
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)" ", errors));
        }
    }

    private static Spliterator<TarArchiveEntry> makeSpliterator(final TarArchiveInputStream f) {
        return new Spliterators.AbstractSpliterator<TarArchiveEntry>(Long.MAX_VALUE, 0){

            @Override
            public boolean tryAdvance(Consumer<? super TarArchiveEntry> action) {
                try {
                    TarArchiveEntry entry = f.getNextTarEntry();
                    if (entry != null) {
                        action.accept((TarArchiveEntry)entry);
                        return true;
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public List<ZoneId> queryAll(double latitude, double longitude) {
        return this.index.query(latitude, longitude);
    }

    public Optional<ZoneId> query(double latitude, double longitude) {
        List<ZoneId> result = this.index.query(latitude, longitude);
        return result.size() > 0 ? Optional.of(result.get(0)) : Optional.empty();
    }

    public List<SameZoneSpan> queryPolyline(double[] points) {
        return this.index.queryPolyline(points);
    }

    public List<ZoneId> getKnownZoneIds() {
        return this.index.getKnownZoneIds();
    }

    public static TimeZoneEngine initialize(boolean accelerateGeometry) {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, accelerateGeometry);
    }

    public static TimeZoneEngine initialize() {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, false);
    }

    public static TimeZoneEngine initialize(TarArchiveInputStream f) {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, false, f);
    }

    public static TimeZoneEngine initialize(double minLat, double minLon, double maxLat, double maxLon, boolean accelerateGeometry, TarArchiveInputStream f) {
        log.info("Initializing with bounding box: {}, {}, {}, {}", new Object[]{minLat, minLon, maxLat, maxLon});
        TimeZoneEngine.validateCoordinates(minLat, minLon, maxLat, maxLon);
        Spliterator<TarArchiveEntry> tarArchiveEntrySpliterator = TimeZoneEngine.makeSpliterator(f);
        Stream<Geojson.Feature> featureStream = StreamSupport.stream(tarArchiveEntrySpliterator, false).map(n -> {
            try {
                if (n != null) {
                    log.debug("Processing archive entry {}", (Object)n.getName());
                    byte[] e = new byte[(int)n.getSize()];
                    f.read(e);
                    return Geojson.Feature.parseFrom((byte[])e);
                }
                throw new RuntimeException("Data entry is not found in file");
            }
            catch (IOException | NullPointerException ex) {
                throw new RuntimeException(ex);
            }
        });
        int numberOfTimezones = 449;
        Envelope boundaries = new Envelope(minLon, minLat, maxLon, maxLat);
        return new TimeZoneEngine(Index.build(featureStream, numberOfTimezones, boundaries, accelerateGeometry));
    }

    /*
     * Exception decompiling
     */
    public static TimeZoneEngine initialize(double minLat, double minLon, double maxLat, double maxLon, boolean accelerateGeometry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

