/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.iakovlev.timeshape.Index;

public final class SameZoneSpan {
    private final Set<ZoneId> zoneIds;
    private final int endIndex;

    public Set<ZoneId> getZoneIds() {
        return new HashSet<ZoneId>(this.zoneIds);
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int hashCode() {
        return Objects.hash(this.zoneIds, this.endIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SameZoneSpan)) {
            return false;
        }
        SameZoneSpan other = (SameZoneSpan)obj;
        return other.endIndex == this.endIndex && other.zoneIds.equals(this.zoneIds);
    }

    public String toString() {
        return String.format("%s: end index %d", this.zoneIds, this.endIndex);
    }

    SameZoneSpan(Set<ZoneId> zoneIds, int endIndex) {
        this.zoneIds = new HashSet<ZoneId>(zoneIds);
        this.endIndex = endIndex;
    }

    static SameZoneSpan fromIndexEntries(List<Index.Entry> entries, int index) {
        return new SameZoneSpan(entries.stream().map(e -> e.zoneId).collect(Collectors.toSet()), index);
    }
}

