/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.OperatorIntersects;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.QuadTree;
import com.esri.core.geometry.SpatialReference;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.iakovlev.timeshape.SameZoneSpan;
import net.iakovlev.timeshape.proto.Geojson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Index
implements Serializable {
    private static final int WGS84_WKID = 4326;
    private final ArrayList<Entry> zoneIds;
    private static final SpatialReference spatialReference = SpatialReference.create((int)4326);
    private final QuadTree quadTree;
    private static final Logger log = LoggerFactory.getLogger(Index.class);

    private Index(QuadTree quadTree, ArrayList<Entry> zoneIds) {
        log.info("Initialized index with {} time zones", (Object)zoneIds.size());
        this.quadTree = quadTree;
        this.zoneIds = zoneIds;
    }

    List<ZoneId> getKnownZoneIds() {
        return this.zoneIds.stream().map(e -> e.zoneId).collect(Collectors.toList());
    }

    List<ZoneId> query(double latitude, double longitude) {
        ArrayList<ZoneId> result = new ArrayList<ZoneId>(2);
        Point point = new Point(longitude, latitude);
        OperatorIntersects operator = OperatorIntersects.local();
        QuadTree.QuadTreeIterator iterator = this.quadTree.getIterator((Geometry)point, 0.0);
        int i = iterator.next();
        while (i >= 0) {
            int element = this.quadTree.getElement(i);
            Entry entry = this.zoneIds.get(element);
            if (operator.execute(entry.geometry, (Geometry)point, spatialReference, null)) {
                result.add(entry.zoneId);
            }
            i = iterator.next();
        }
        return result;
    }

    List<SameZoneSpan> queryPolyline(double[] line) {
        int i;
        Polyline polyline = new Polyline();
        ArrayList<Point> points = new ArrayList<Point>(line.length / 2);
        for (i = 0; i < line.length - 1; i += 2) {
            Point p = new Point(line[i + 1], line[i]);
            points.add(p);
        }
        polyline.startPath((Point)points.get(0));
        for (i = 1; i < points.size(); ++i) {
            polyline.lineTo((Point)points.get(i));
        }
        QuadTree.QuadTreeIterator iterator = this.quadTree.getIterator((Geometry)polyline, 0.0);
        ArrayList<Entry> potentiallyMatchingEntries = new ArrayList<Entry>();
        int i2 = iterator.next();
        while (i2 >= 0) {
            int element = this.quadTree.getElement(i2);
            Entry entry = this.zoneIds.get(element);
            potentiallyMatchingEntries.add(entry);
            i2 = iterator.next();
        }
        ArrayList<SameZoneSpan> sameZoneSegments = new ArrayList<SameZoneSpan>();
        List<Entry> currentEntry = null;
        int index = 0;
        boolean lastWasEmpty = false;
        OperatorIntersects operator = OperatorIntersects.local();
        while (index < points.size()) {
            Point p = (Point)points.get(index);
            if (currentEntry == null) {
                currentEntry = potentiallyMatchingEntries.stream().filter(e -> operator.execute(e.geometry, (Geometry)p, spatialReference, null)).collect(Collectors.toList());
            }
            if (currentEntry.isEmpty()) {
                currentEntry = null;
                lastWasEmpty = true;
                ++index;
                continue;
            }
            if (lastWasEmpty) {
                lastWasEmpty = false;
                sameZoneSegments.add(SameZoneSpan.fromIndexEntries(Collections.emptyList(), (index - 1) * 2 + 1));
                continue;
            }
            if (currentEntry.stream().allMatch(e -> operator.execute(e.geometry, (Geometry)p, spatialReference, null))) {
                if (index == points.size() - 1) {
                    sameZoneSegments.add(SameZoneSpan.fromIndexEntries(currentEntry, index * 2 + 1));
                }
                ++index;
                continue;
            }
            sameZoneSegments.add(SameZoneSpan.fromIndexEntries(currentEntry, (index - 1) * 2 + 1));
            currentEntry = null;
        }
        if (lastWasEmpty) {
            sameZoneSegments.add(SameZoneSpan.fromIndexEntries(Collections.emptyList(), index * 2 - 1));
        }
        return sameZoneSegments;
    }

    private static Polygon buildPoly(Geojson.Polygon from) {
        Polygon poly = new Polygon();
        from.getCoordinatesList().stream().map(Geojson.LineString::getCoordinatesList).forEachOrdered(lp -> {
            poly.startPath((double)((Geojson.Position)lp.get(0)).getLon(), (double)((Geojson.Position)lp.get(0)).getLat());
            lp.subList(1, lp.size()).forEach(p -> poly.lineTo((double)p.getLon(), (double)p.getLat()));
        });
        return poly;
    }

    static Index build(Stream<Geojson.Feature> features, int size, Envelope boundaries) {
        return Index.build(features, size, boundaries, false);
    }

    private static Stream<Polygon> getPolygons(Geojson.Feature f) {
        if (f.getGeometry().hasPolygon()) {
            return Stream.of(Index.buildPoly(f.getGeometry().getPolygon()));
        }
        if (f.getGeometry().hasMultiPolygon()) {
            Geojson.MultiPolygon multiPolygonProto = f.getGeometry().getMultiPolygon();
            return multiPolygonProto.getCoordinatesList().stream().map(Index::buildPoly);
        }
        throw new RuntimeException("Unknown geometry type");
    }

    static Index build(Stream<Geojson.Feature> features, int size, Envelope boundaries, boolean accelerateGeometry) {
        Envelope2D boundariesEnvelope = new Envelope2D();
        boundaries.queryEnvelope2D(boundariesEnvelope);
        QuadTree quadTree = new QuadTree(boundariesEnvelope, 8);
        Envelope2D env = new Envelope2D();
        ArrayList<Entry> zoneIds = new ArrayList<Entry>(size);
        PrimitiveIterator.OfInt indices = IntStream.iterate(0, i -> i + 1).iterator();
        ArrayList unknownZones = new ArrayList();
        OperatorIntersects operatorIntersects = OperatorIntersects.local();
        features.forEach(f -> {
            String zoneIdName = f.getProperties(0).getValueString();
            try {
                ZoneId zoneId = ZoneId.of(zoneIdName);
                Index.getPolygons(f).forEach(polygon -> {
                    if (GeometryEngine.contains((Geometry)boundaries, (Geometry)polygon, (SpatialReference)spatialReference)) {
                        log.debug("Adding zone {} to index", (Object)zoneIdName);
                        if (accelerateGeometry) {
                            operatorIntersects.accelerateGeometry((Geometry)polygon, spatialReference, Geometry.GeometryAccelerationDegree.enumMild);
                        }
                        polygon.queryEnvelope2D(env);
                        int index = indices.next();
                        quadTree.insert(index, env);
                        zoneIds.add(index, new Entry(zoneId, (Geometry)polygon));
                    } else {
                        log.debug("Not adding zone {} to index because it's out of provided boundaries", (Object)zoneIdName);
                    }
                });
            }
            catch (Exception ex) {
                unknownZones.add(zoneIdName);
            }
        });
        if (unknownZones.size() != 0) {
            String allUnknownZones = String.join((CharSequence)", ", unknownZones);
            log.error("Some of the zone ids were not recognized by the Java runtime and will be ignored. The most probable reason for this is outdated Java runtime version. The following zones were not recognized: " + allUnknownZones);
        }
        return new Index(quadTree, zoneIds);
    }

    static final class Entry
    implements Serializable {
        final ZoneId zoneId;
        final Geometry geometry;

        Entry(ZoneId zoneId, Geometry geometry) {
            this.zoneId = zoneId;
            this.geometry = geometry;
        }
    }
}

