/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.demo.dcp.policy;

import org.eclipse.edc.connector.controlplane.catalog.spi.policy.CatalogPolicyContext;
import org.eclipse.edc.connector.controlplane.contract.spi.policy.ContractNegotiationPolicyContext;
import org.eclipse.edc.connector.controlplane.contract.spi.policy.TransferProcessPolicyContext;
import org.eclipse.edc.demo.dcp.policy.DataAccessLevelFunction;
import org.eclipse.edc.demo.dcp.policy.MembershipCredentialEvaluationFunction;
import org.eclipse.edc.policy.engine.spi.AtomicConstraintRuleFunction;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.engine.spi.RuleBindingRegistry;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

public class PolicyEvaluationExtension
implements ServiceExtension {
    @Inject
    private PolicyEngine policyEngine;
    @Inject
    private RuleBindingRegistry ruleBindingRegistry;

    public void initialize(ServiceExtensionContext context) {
        this.bindPermissionFunction(MembershipCredentialEvaluationFunction.create(), TransferProcessPolicyContext.class, "transfer.process", "MembershipCredential");
        this.bindPermissionFunction(MembershipCredentialEvaluationFunction.create(), ContractNegotiationPolicyContext.class, "contract.negotiation", "MembershipCredential");
        this.bindPermissionFunction(MembershipCredentialEvaluationFunction.create(), CatalogPolicyContext.class, "catalog", "MembershipCredential");
        this.registerDataAccessLevelFunction();
    }

    private void registerDataAccessLevelFunction() {
        String accessLevelKey = "DataAccess.level";
        this.bindDutyFunction(DataAccessLevelFunction.create(), TransferProcessPolicyContext.class, "transfer.process", accessLevelKey);
        this.bindDutyFunction(DataAccessLevelFunction.create(), ContractNegotiationPolicyContext.class, "contract.negotiation", accessLevelKey);
        this.bindDutyFunction(DataAccessLevelFunction.create(), CatalogPolicyContext.class, "catalog", accessLevelKey);
    }

    private <C extends PolicyContext> void bindPermissionFunction(AtomicConstraintRuleFunction<Permission, C> function, Class<C> contextClass, String scope, String constraintType) {
        this.ruleBindingRegistry.bind("use", scope);
        this.ruleBindingRegistry.bind("http://www.w3.org/ns/odrl/2/use", scope);
        this.ruleBindingRegistry.bind(constraintType, scope);
        this.policyEngine.registerFunction(contextClass, Permission.class, constraintType, function);
    }

    private <C extends PolicyContext> void bindDutyFunction(AtomicConstraintRuleFunction<Duty, C> function, Class<C> contextClass, String scope, String constraintType) {
        this.ruleBindingRegistry.bind("use", scope);
        this.ruleBindingRegistry.bind("http://www.w3.org/ns/odrl/2/use", scope);
        this.ruleBindingRegistry.bind(constraintType, scope);
        this.policyEngine.registerFunction(contextClass, Duty.class, constraintType, function);
    }
}

