/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.demo.dcp.policy;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.edc.demo.dcp.policy.AbstractCredentialEvaluationFunction;
import org.eclipse.edc.iam.verifiablecredentials.spi.model.VerifiableCredential;
import org.eclipse.edc.participant.spi.ParticipantAgent;
import org.eclipse.edc.participant.spi.ParticipantAgentPolicyContext;
import org.eclipse.edc.policy.engine.spi.AtomicConstraintRuleFunction;
import org.eclipse.edc.policy.model.Operator;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.spi.result.Result;

public class MembershipCredentialEvaluationFunction<C extends ParticipantAgentPolicyContext>
extends AbstractCredentialEvaluationFunction
implements AtomicConstraintRuleFunction<Permission, C> {
    public static final String MEMBERSHIP_CONSTRAINT_KEY = "MembershipCredential";
    private static final String MEMBERSHIP_CLAIM = "membership";
    private static final String SINCE_CLAIM = "since";
    private static final String ACTIVE = "active";

    private MembershipCredentialEvaluationFunction() {
    }

    public static <C extends ParticipantAgentPolicyContext> MembershipCredentialEvaluationFunction<C> create() {
        return new MembershipCredentialEvaluationFunction<C>(){};
    }

    public boolean evaluate(Operator operator, Object rightOperand, Permission permission, C policyContext) {
        if (!operator.equals((Object)Operator.EQ)) {
            policyContext.reportProblem("Invalid operator '%s', only accepts '%s'".formatted(operator, Operator.EQ));
            return false;
        }
        if (!ACTIVE.equals(rightOperand)) {
            policyContext.reportProblem("Right-operand must be equal to '%s', but was '%s'".formatted(ACTIVE, rightOperand));
            return false;
        }
        ParticipantAgent pa = policyContext.participantAgent();
        if (pa == null) {
            policyContext.reportProblem("No ParticipantAgent found on context.");
            return false;
        }
        Result<List<VerifiableCredential>> credentialResult = this.getCredentialList(pa);
        if (credentialResult.failed()) {
            policyContext.reportProblem(credentialResult.getFailureDetail());
            return false;
        }
        return ((List)credentialResult.getContent()).stream().filter(vc -> vc.getType().stream().anyMatch(t -> t.endsWith(MEMBERSHIP_CONSTRAINT_KEY))).flatMap(vc -> vc.getCredentialSubject().stream().filter(cs -> cs.getClaims().containsKey(MEMBERSHIP_CLAIM))).anyMatch(credential -> {
            Map membershipClaim = (Map)credential.getClaim("https://w3id.org/mvd/credentials/", MEMBERSHIP_CLAIM);
            Instant membershipStartDate = Instant.parse(membershipClaim.get(SINCE_CLAIM).toString());
            return membershipStartDate.isBefore(Instant.now());
        });
    }
}

