/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.demo.dcp.policy;

import java.util.List;
import java.util.Objects;
import org.eclipse.edc.demo.dcp.policy.AbstractCredentialEvaluationFunction;
import org.eclipse.edc.iam.verifiablecredentials.spi.model.VerifiableCredential;
import org.eclipse.edc.participant.spi.ParticipantAgent;
import org.eclipse.edc.participant.spi.ParticipantAgentPolicyContext;
import org.eclipse.edc.policy.engine.spi.AtomicConstraintRuleFunction;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Operator;
import org.eclipse.edc.spi.result.Result;

public class DataAccessLevelFunction<C extends ParticipantAgentPolicyContext>
extends AbstractCredentialEvaluationFunction
implements AtomicConstraintRuleFunction<Duty, C> {
    private static final String DATAPROCESSOR_CRED_TYPE = "DataProcessorCredential";

    private DataAccessLevelFunction() {
    }

    public static <C extends ParticipantAgentPolicyContext> DataAccessLevelFunction<C> create() {
        return new DataAccessLevelFunction<C>(){};
    }

    public boolean evaluate(Operator operator, Object rightOperand, Duty duty, C policyContext) {
        if (!operator.equals((Object)Operator.EQ)) {
            policyContext.reportProblem("Cannot evaluate operator %s, only %s is supported".formatted(operator, Operator.EQ));
            return false;
        }
        ParticipantAgent pa = policyContext.participantAgent();
        if (pa == null) {
            policyContext.reportProblem("ParticipantAgent not found on PolicyContext");
            return false;
        }
        Result<List<VerifiableCredential>> credentialResult = this.getCredentialList(pa);
        if (credentialResult.failed()) {
            policyContext.reportProblem(credentialResult.getFailureDetail());
            return false;
        }
        return ((List)credentialResult.getContent()).stream().filter(vc -> vc.getType().stream().anyMatch(t -> t.endsWith(DATAPROCESSOR_CRED_TYPE))).flatMap(credential -> credential.getCredentialSubject().stream()).anyMatch(credentialSubject -> {
            Object version = credentialSubject.getClaim("https://w3id.org/mvd/credentials/", "contractVersion");
            Object level = credentialSubject.getClaim("https://w3id.org/mvd/credentials/", "level");
            return version != null && Objects.equals(level, rightOperand);
        });
    }
}

