/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.demo.dcp.policy;

import java.util.List;
import org.eclipse.edc.iam.verifiablecredentials.spi.model.VerifiableCredential;
import org.eclipse.edc.participant.spi.ParticipantAgent;
import org.eclipse.edc.spi.result.Result;

public class AbstractCredentialEvaluationFunction {
    private static final String VC_CLAIM = "vc";
    protected static final String MVD_NAMESPACE = "https://w3id.org/mvd/credentials/";

    protected Result<List<VerifiableCredential>> getCredentialList(ParticipantAgent agent) {
        Object vcListClaim = agent.getClaims().get(VC_CLAIM);
        if (vcListClaim == null) {
            return Result.failure((String)"ParticipantAgent did not contain a '%s' claim.".formatted(VC_CLAIM));
        }
        if (!(vcListClaim instanceof List)) {
            return Result.failure((String)"ParticipantAgent contains a '%s' claim, but the type is incorrect. Expected %s, received %s.".formatted(VC_CLAIM, List.class.getName(), vcListClaim.getClass().getName()));
        }
        List vcList = (List)vcListClaim;
        if (vcList.isEmpty()) {
            return Result.failure((String)"ParticipantAgent contains a '%s' claim but it did not contain any VerifiableCredentials.".formatted(VC_CLAIM));
        }
        return Result.success((Object)vcList);
    }
}

