/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.demo.dcp.core;

import com.apicatalog.vc.suite.SignatureSuite;
import java.util.Map;
import java.util.Set;
import org.eclipse.edc.demo.dcp.core.DataAccessCredentialScopeExtractor;
import org.eclipse.edc.demo.dcp.core.DefaultScopeMappingFunction;
import org.eclipse.edc.iam.identitytrust.spi.scope.ScopeExtractor;
import org.eclipse.edc.iam.identitytrust.spi.scope.ScopeExtractorRegistry;
import org.eclipse.edc.iam.identitytrust.spi.verification.SignatureSuiteRegistry;
import org.eclipse.edc.iam.verifiablecredentials.spi.model.Issuer;
import org.eclipse.edc.iam.verifiablecredentials.spi.validation.TrustedIssuerRegistry;
import org.eclipse.edc.policy.context.request.spi.RequestCatalogPolicyContext;
import org.eclipse.edc.policy.context.request.spi.RequestContractNegotiationPolicyContext;
import org.eclipse.edc.policy.context.request.spi.RequestTransferProcessPolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.security.signature.jws2020.Jws2020SignatureSuite;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;

public class DcpPatchExtension
implements ServiceExtension {
    @Inject
    private TypeManager typeManager;
    @Inject
    private PolicyEngine policyEngine;
    @Inject
    private SignatureSuiteRegistry signatureSuiteRegistry;
    @Inject
    private TrustedIssuerRegistry trustedIssuerRegistry;
    @Inject
    private ScopeExtractorRegistry scopeExtractorRegistry;
    @Inject
    private TypeTransformerRegistry typeTransformerRegistry;

    public void initialize(ServiceExtensionContext context) {
        Jws2020SignatureSuite suite = new Jws2020SignatureSuite(this.typeManager.getMapper("json-ld"));
        this.signatureSuiteRegistry.register("JsonWebSignature2020", (SignatureSuite)suite);
        this.trustedIssuerRegistry.register(new Issuer("did:web:dataspace-issuer", Map.of()), "*");
        this.trustedIssuerRegistry.register(new Issuer("did:web:localhost%3A9876", Map.of()), "*");
        DefaultScopeMappingFunction contextMappingFunction = new DefaultScopeMappingFunction(Set.of("org.eclipse.edc.vc.type:MembershipCredential:read"));
        this.policyEngine.registerPostValidator(RequestCatalogPolicyContext.class, contextMappingFunction::apply);
        this.policyEngine.registerPostValidator(RequestContractNegotiationPolicyContext.class, contextMappingFunction::apply);
        this.policyEngine.registerPostValidator(RequestTransferProcessPolicyContext.class, contextMappingFunction::apply);
        this.scopeExtractorRegistry.registerScopeExtractor((ScopeExtractor)new DataAccessCredentialScopeExtractor());
        this.typeTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(this.typeManager.getMapper("json-ld")));
    }
}

