/*
 * Decompiled with CFR 0.152.
 */
package net.hyshan.hou.starter.log.annotation;

import lombok.Generated;
import net.hyshan.hou.common.base.utils.SpringContextHolder;
import net.hyshan.hou.starter.log.annotation.L;
import net.hyshan.hou.starter.log.annotation.Position;
import net.hyshan.hou.starter.log.event.Log;
import net.hyshan.hou.starter.log.event.LogEvent;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

@Aspect
public class LogStarterAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogStarterAspect.class);

    @Around(value="@annotation(l)")
    public Object aroundLoggable(ProceedingJoinPoint joinPoint, L l) throws Throwable {
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Log.LogBuilder value = Log.builder().id(System.currentTimeMillis()).name(className).method(methodName).value(l.value()).audit(l.audit()).store(l.store()).auditLevel(l.auditLevel()).from(l.from()).level(l.level()).status(true);
        try {
            SpringContextHolder.publishEvent((ApplicationEvent)new LogEvent(value.time(System.currentTimeMillis()).position(Position.BEFORE).build()));
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            value.status(false);
            throw e;
        }
        finally {
            SpringContextHolder.publishEvent((ApplicationEvent)new LogEvent(value.time(System.currentTimeMillis()).position(Position.AFTER).build()));
        }
    }
}

