package net.hyshan.hou.starter.log.event;

import net.hyshan.hou.common.base.data.Note;
import net.hyshan.hou.common.base.data.VO;
import net.hyshan.hou.starter.log.annotation.AuditLevel;
import net.hyshan.hou.starter.log.annotation.From;
import net.hyshan.hou.starter.log.annotation.Position;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.boot.logging.LogLevel;

@Data
@Builder
@Accessors(chain = true)
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class Log extends VO {
    private long id;
    private String name;
    private String method;
    private Position position;
    private String value;
    private LogLevel level;
    private From from;
    private boolean audit;
    private AuditLevel auditLevel;

    @Note("执行结果,是否成功")
    private boolean status=true;
    private boolean store;
    private long time;
}
