package net.hyshan.hou.starter.log.config;

import net.hyshan.hou.starter.log.annotation.LogStarterAspect;
import net.hyshan.hou.starter.log.event.LogListener;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * @author lengleng
 * @date 2019/2/1 日志自动配置
 */
@EnableAsync
@RequiredArgsConstructor
@ConditionalOnWebApplication
@Configuration(proxyBeanMethods = false)
public class LogAutoConfiguration {

    @Bean
    public LogListener defaultLogListener() {
        return new LogListener();
    }

    @Bean
    public LogStarterAspect logStarterAspect() {
        return new LogStarterAspect();
    }

}
