package net.hyshan.hou.starter.log.annotation;

import net.hyshan.hou.common.base.utils.SpringContextHolder;
import net.hyshan.hou.starter.log.event.Log;
import net.hyshan.hou.starter.log.event.LogEvent;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Slf4j
@Aspect
public class LogStarterAspect {

    @Around("@annotation(l)")
    public Object aroundLoggable(ProceedingJoinPoint joinPoint, L l) throws Throwable {
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();

        Log.LogBuilder value = Log.builder().id(System.currentTimeMillis()).name(className).method(methodName).value(l.value()).audit(l.audit()).store(l.store()).auditLevel(l.auditLevel()).from(l.from()).level(l.level()).status(true);
        try {
            SpringContextHolder.publishEvent(new LogEvent(value.time(System.currentTimeMillis()).position(Position.BEFORE).build()));
            return joinPoint.proceed();
        } catch (Exception e) {
            value.status(false);
            throw e;
        } finally {
            SpringContextHolder.publishEvent(new LogEvent(value.time(System.currentTimeMillis()).position(Position.AFTER).build()));
        }
    }
}