package net.hyshan.hou.starter.log.annotation;

import org.springframework.boot.logging.LogLevel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface L {
    String value() default "用于说明作用的信息";

    LogLevel level() default LogLevel.INFO;


    From from() default From.DEFAULT;

    /*是否时审计日志，默认为false*/
    boolean audit() default false;

    /*审计日志等级*/
    AuditLevel auditLevel() default AuditLevel.INFO;

    /*是否存储日志，默认为true*/
    boolean store() default false;
}