package net.hyshan.hou.starter.log.annotation;

import lombok.Getter;

/**
 * 属于特定类型的方法，或者时特定业务分层的方法
 */
@Getter
public enum From {

    /*没有主动设置，默认值*/
    DEFAULT("DEFAULT"),
    /*api 调用层*/
    API("API"),
    /*service 调用层*/
    SERVICE("SERVICE"),
    /*dao 调用层*/
    DAO("DAO"),
    /*数据库层*/
    DB("DB"),
    /*客户端调用层，远程服务访问*/
    CLIENT("CLIENT");

    private final String type;

    From(String type) {
        this.type = type;
    }

}