/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;

public class TriggerableProperties
extends Properties {
    protected final Map triggers = new HashMap();
    protected final Map properties = new HashMap();

    protected TriggerableProperties() {
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Property property;
        String oldValue = super.getProperty(key);
        Object object = super.setProperty(key, value);
        if (oldValue == null && object != null) {
            oldValue = object.toString();
        }
        if ((property = (Property)this.properties.get(key)) != null && this.triggersAreEnabled()) {
            try {
                property.onChange(oldValue, value);
            }
            catch (Trigger.VetoRT vex) {
                this.superSetProperty(key, oldValue);
                try {
                    property.onChange(value, oldValue);
                }
                catch (Trigger.VetoRT vetoRT) {
                    // empty catch block
                }
                throw vex;
            }
        }
        return oldValue;
    }

    public boolean triggersAreEnabled() {
        return true;
    }

    public Property getPropertyDefinition(String path) {
        List propertyList = this.getPropertyList();
        for (int i = 0; i < propertyList.size(); ++i) {
            Property property = (Property)propertyList.get(i);
            if (!property.getPath().equals(path)) continue;
            return property;
        }
        return null;
    }

    private void superSetProperty(String key, String oldValue) {
        if (oldValue != null) {
            super.setProperty(key, oldValue);
        }
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public void register(Property property) {
        this.properties.put(property.getPath(), property);
    }

    public Collection getProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public List getPropertyList() {
        Field[] fields = this.getClass().getFields();
        ArrayList<Property> list = new ArrayList<Property>();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers()) || !Property.class.isAssignableFrom(field.getType())) continue;
            try {
                list.add((Property)field.get(this));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while accessing property '" + field.getName() + "'", e);
            }
        }
        return list;
    }
}

