/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.plugins.rpc.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import net.hserver.plugins.rpc.codec.InvokeServiceData;
import net.hserver.plugins.rpc.codec.Msg;
import net.hserver.plugins.rpc.codec.MsgType;
import net.hserver.plugins.rpc.server.InvokerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandler
extends SimpleChannelInboundHandler<Msg> {
    private static final Logger log = LoggerFactory.getLogger(ServerHandler.class);

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Msg msg) throws Exception {
        if (msg.getMsgType() == MsgType.INVOKER) {
            InvokeServiceData data = (InvokeServiceData)msg.getData();
            InvokerHandler.invoker(data, channelHandlerContext);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u65ad\u5f00\u5f02\u5e38\u4fe1\u606f\uff1a\r\n{}", (Object)cause.getMessage());
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass())) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                log.debug("\u8bfb\u7a7a\u95f2\uff0c\u5173\u95ed\u65e0\u7528\u7684\u8fde\u63a5");
                ctx.disconnect();
            } else if (event.state() == IdleState.WRITER_IDLE || event.state() == IdleState.ALL_IDLE) {
                // empty if block
            }
        }
    }
}

