/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.plugins.rpc.server;

import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import net.hserver.plugins.rpc.codec.InvokeServiceData;
import net.hserver.plugins.rpc.codec.Msg;
import net.hserver.plugins.rpc.codec.MsgCode;
import net.hserver.plugins.rpc.codec.MsgType;
import net.hserver.plugins.rpc.codec.ResultData;
import top.hserver.core.ioc.IocUtil;

public class InvokerHandler {
    static void invoker(InvokeServiceData data, ChannelHandlerContext ctx) {
        if (data != null) {
            String aClass = data.getaClass();
            Object bean = IocUtil.getBean((String)aClass);
            try {
                Method method = bean.getClass().getMethod(data.getMethod(), data.getParameterTypes());
                method.setAccessible(true);
                CompletableFuture invoke = (CompletableFuture)method.invoke(bean, data.getObjects());
                ResultData resultData = new ResultData();
                resultData.setCode(MsgCode.SUCCESS);
                resultData.setRequestId(data.getRequestId());
                Msg<ResultData> msg2 = new Msg<ResultData>();
                msg2.setMsgType(MsgType.RESULT);
                resultData.setData(invoke);
                msg2.setData(resultData);
                ctx.writeAndFlush(msg2);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ResultData resultData = new ResultData();
                resultData.setError(e);
                resultData.setRequestId(data.getRequestId());
                resultData.setCode(MsgCode.ERROR);
                Msg<ResultData> msg2 = new Msg<ResultData>();
                msg2.setMsgType(MsgType.RESULT);
                msg2.setData(resultData);
                ctx.writeAndFlush(msg2);
            }
        } else {
            ResultData resultData = new ResultData();
            resultData.setData("\u7a7a\u8c03\u7528");
            resultData.setCode(MsgCode.ERROR);
            Msg<ResultData> msg2 = new Msg<ResultData>();
            msg2.setMsgType(MsgType.RESULT);
            msg2.setData(resultData);
            ctx.writeAndFlush(msg2);
        }
    }
}

