/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.plugins.rpc.codec;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.hserver.plugins.rpc.codec.ServiceData;

public class DynamicRoundRobin {
    private final List<ServiceData> list = new CopyOnWriteArrayList<ServiceData>();
    private AtomicInteger pos = new AtomicInteger(0);

    public void add(ServiceData t) {
        this.list.add(t);
    }

    public List<ServiceData> getAll() {
        return this.list;
    }

    public boolean remove(ServiceData t) {
        return this.list.remove(t);
    }

    public int size() {
        return this.list.size();
    }

    public ServiceData choose() {
        int size;
        while ((size = this.list.size()) != 0) {
            int p = this.pos.getAndIncrement();
            if (p > size - 1) {
                this.pos.set(0);
                continue;
            }
            try {
                return this.list.get(p);
            }
            catch (IndexOutOfBoundsException e) {
                this.pos.set(0);
                continue;
            }
            break;
        }
        return null;
    }
}

