/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedSearch
extends TwitterResponse {
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private int id;
    private static final long serialVersionUID = 3083819860391598212L;

    SavedSearch(Response res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    SavedSearch(Response res, JSONObject json) throws TwitterException {
        super(res);
        this.init(json);
    }

    SavedSearch(JSONObject savedSearch) throws TwitterException {
        this.init(savedSearch);
    }

    static List<SavedSearch> constructSavedSearches(Response res) throws TwitterException {
        JSONArray json = res.asJSONArray();
        try {
            ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                savedSearches.add(new SavedSearch(res, json.getJSONObject(i)));
            }
            return savedSearches;
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(res.asString()).toString(), jsone);
        }
    }

    private void init(JSONObject savedSearch) throws TwitterException {
        try {
            this.createdAt = SavedSearch.parseDate(savedSearch.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.query = SavedSearch.getString("query", savedSearch, true);
            this.position = SavedSearch.getInt("position", savedSearch);
            this.name = SavedSearch.getString("name", savedSearch, true);
            this.id = SavedSearch.getInt("id", savedSearch);
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(savedSearch.toString()).toString(), jsone);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getQuery() {
        return this.query;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedSearch)) {
            return false;
        }
        SavedSearch that = (SavedSearch)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.position != that.position) {
            return false;
        }
        if (!this.createdAt.equals(that.createdAt)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.query.equals(that.query);
    }

    public int hashCode() {
        int result = this.createdAt.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return new StringBuffer().append("SavedSearch{createdAt=").append(this.createdAt).append(", query='").append(this.query).append('\'').append(", position=").append(this.position).append(", name='").append(this.name).append('\'').append(", id=").append(this.id).append('}').toString();
    }
}

