/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.Configuration;
import twitter4j.Status;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.TwitterException;
import twitter4j.TwitterSupport;
import twitter4j.http.PostParameter;

public class TwitterStream
extends TwitterSupport {
    private static final boolean DEBUG = Configuration.getDebug();
    private static final String STREAM_BASE_URL = "http://stream.twitter.com/";
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private int retryPerMinutes = 1;

    public TwitterStream(String userId, String password) {
        super(userId, password);
    }

    public TwitterStream(String userId, String password, StatusListener listener) {
        super(userId, password);
        this.statusListener = listener;
    }

    public void firehose(int count) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{new Integer(count)}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFirehoseStream((Integer)this.args[0]);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        try {
            return new StatusStream(this.http.post("http://stream.twitter.com/firehose.json", new PostParameter[]{new PostParameter("count", String.valueOf(count))}, true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void gardenhose() throws TwitterException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getGardenhoseStream();
            }
        });
    }

    public StatusStream getGardenhoseStream() throws TwitterException {
        try {
            return new StatusStream(this.http.get("http://stream.twitter.com/gardenhose.json", true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void spritzer() throws TwitterException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getSpritzerStream();
            }
        });
    }

    public StatusStream getSpritzerStream() throws TwitterException {
        try {
            return new StatusStream(this.http.get("http://stream.twitter.com/spritzer.json", true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void birddog(int count, int[] follow) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{new Integer(count), follow}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getBirddogStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getBirddogStream(int count, int[] follow) throws TwitterException {
        try {
            return new StatusStream(this.http.post("http://stream.twitter.com/birddog.json", new PostParameter[]{new PostParameter("count", String.valueOf(count)), new PostParameter("follow", this.toFollowString(follow))}, true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void shadow(int count, int[] follow) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{new Integer(count), follow}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getShadowStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getShadowStream(int count, int[] follow) throws TwitterException {
        try {
            return new StatusStream(this.http.post("http://stream.twitter.com/shadow.json", new PostParameter[]{new PostParameter("count", String.valueOf(count)), new PostParameter("follow", this.toFollowString(follow))}, true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void follow(int[] follow) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{follow}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFollowStream((int[])this.args[0]);
            }
        });
    }

    public StatusStream getFollowStream(int[] follow) throws TwitterException {
        try {
            return new StatusStream(this.http.post("http://stream.twitter.com/follow.json", new PostParameter[]{new PostParameter("follow", this.toFollowString(follow))}, true));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    private String toFollowString(int[] follows) {
        StringBuffer buf = new StringBuffer(11 * follows.length);
        int[] arr$ = follows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int follow = arr$[i$];
            if (0 != buf.length()) {
                buf.append(" ");
            }
            buf.append(follow);
        }
        return buf.toString();
    }

    private synchronized void startHandler(StreamHandlingThread handler) throws TwitterException {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private void log(String message, String message2) {
        if (DEBUG) {
            this.log(message + message2);
        }
    }

    public /* synthetic */ void setRetryIntervalSecs(int x0) {
        super.setRetryIntervalSecs(x0);
    }

    public /* synthetic */ void setRetryCount(int x0) {
        super.setRetryCount(x0);
    }

    public /* synthetic */ void setRequestHeader(String x0, String x1) {
        super.setRequestHeader(x0, x1);
    }

    public /* synthetic */ String getSource() {
        return super.getSource();
    }

    public /* synthetic */ void setSource(String x0) {
        super.setSource(x0);
    }

    public /* synthetic */ void setHttpReadTimeout(int x0) {
        super.setHttpReadTimeout(x0);
    }

    public /* synthetic */ void setHttpConnectionTimeout(int x0) {
        super.setHttpConnectionTimeout(x0);
    }

    public /* synthetic */ void setHttpProxyAuth(String x0, String x1) {
        super.setHttpProxyAuth(x0, x1);
    }

    public /* synthetic */ void setHttpProxy(String x0, int x1) {
        super.setHttpProxy(x0, x1);
    }

    public /* synthetic */ String getPassword() {
        return super.getPassword();
    }

    public /* synthetic */ void setPassword(String x0) {
        super.setPassword(x0);
    }

    public /* synthetic */ String getUserId() {
        return super.getUserId();
    }

    public /* synthetic */ void setUserId(String x0) {
        super.setUserId(x0);
    }

    public /* synthetic */ String getClientURL() {
        return super.getClientURL();
    }

    public /* synthetic */ void setClientURL(String x0) {
        super.setClientURL(x0);
    }

    public /* synthetic */ String getClientVersion() {
        return super.getClientVersion();
    }

    public /* synthetic */ void setClientVersion(String x0) {
        super.setClientVersion(x0);
    }

    public /* synthetic */ String getUserAgent() {
        return super.getUserAgent();
    }

    public /* synthetic */ void setUserAgent(String x0) {
        super.setUserAgent(x0);
    }

    abstract class StreamHandlingThread
    extends Thread {
        StatusStream stream;
        Object[] args;
        private List<Long> retryHistory;
        private static final String NAME = "Twitter Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread(Object[] args) {
            super("Twitter Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
            this.args = args;
            this.retryHistory = new ArrayList<Long>(TwitterStream.this.retryPerMinutes);
        }

        public void run() {
            while (!this.closed) {
                try {
                    Status status;
                    if (this.retryHistory.size() > 0 && System.currentTimeMillis() - this.retryHistory.get(0) > 60000L) {
                        this.retryHistory.remove(0);
                    }
                    if (this.retryHistory.size() < TwitterStream.this.retryPerMinutes) {
                        this.setStatus("[establishing connection]");
                        while (!this.closed && null == this.stream) {
                            if (this.retryHistory.size() >= TwitterStream.this.retryPerMinutes) continue;
                            this.retryHistory.add(new Long(System.currentTimeMillis()));
                            this.stream = this.getStream();
                        }
                    } else {
                        long timeToSleep = 60000L - (System.currentTimeMillis() - this.retryHistory.get(this.retryHistory.size() - 1));
                        this.setStatus("[retry limit reached. sleeping for " + timeToSleep / 1000L + " secs]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                    if (null == this.stream) continue;
                    this.setStatus("[receiving stream]");
                    while (!this.closed && null != (status = this.stream.next())) {
                        TwitterStream.this.log("received:", status.toString());
                        if (null == TwitterStream.this.statusListener) continue;
                        TwitterStream.this.statusListener.onStatus(status);
                    }
                }
                catch (TwitterException te) {
                    te.printStackTrace();
                    TwitterStream.this.log(te.getMessage());
                    TwitterStream.this.statusListener.onException(te);
                }
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[disposing thread]");
            if (null != this.stream) {
                this.stream.close();
                this.closed = true;
            }
        }

        private void setStatus(String message) {
            String actualMessage = NAME + message;
            this.setName(actualMessage);
            TwitterStream.this.log(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }
}

