/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.http.HttpClient;

public class TwitterSupport
implements Serializable {
    protected HttpClient http = new HttpClient();
    protected String source;
    private static final long serialVersionUID = -7550633067620779906L;
    static final String VERSION = "2.0.4";

    TwitterSupport() {
        this(null, null);
    }

    TwitterSupport(String userId, String password) {
        this.setUserAgent("twitter4j http://yusuke.homeip.net/twitter4j/ /2.0.4");
        this.setSource("Twitter4J");
        this.setClientVersion(VERSION);
        this.setClientURL("http://yusuke.homeip.net/twitter4j/en/twitter4j-2.0.4.xml");
        this.setUserId(userId);
        this.setPassword(password);
    }

    public void setUserAgent(String userAgent) {
        this.http.setUserAgent(System.getProperty("twitter4j.http.userAgent", userAgent));
    }

    public String getUserAgent() {
        return this.http.getUserAgent();
    }

    public void setClientVersion(String version) {
        this.setRequestHeader("X-Twitter-Client-Version", System.getProperty("twitter4j.clientVersion", version));
    }

    public String getClientVersion() {
        return this.http.getRequestHeader("X-Twitter-Client-Version");
    }

    public void setClientURL(String clientURL) {
        this.setRequestHeader("X-Twitter-Client-URL", System.getProperty("twitter4j.clientURL", clientURL));
    }

    public String getClientURL() {
        return this.http.getRequestHeader("X-Twitter-Client-URL");
    }

    public synchronized void setUserId(String userId) {
        this.http.setUserId(System.getProperty("twitter4j.user", userId));
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public synchronized void setPassword(String password) {
        this.http.setPassword(System.getProperty("twitter4j.password", password));
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public void setHttpProxy(String proxyHost, int proxyPort) {
        this.http.setProxyHost(proxyHost);
        this.http.setProxyPort(proxyPort);
    }

    public void setHttpProxyAuth(String proxyUser, String proxyPass) {
        this.http.setProxyAuthUser(proxyUser);
        this.http.setProxyAuthPassword(proxyPass);
    }

    public void setHttpConnectionTimeout(int connectionTimeout) {
        this.http.setConnectionTimeout(connectionTimeout);
    }

    public void setHttpReadTimeout(int readTimeoutMilliSecs) {
        this.http.setReadTimeout(readTimeoutMilliSecs);
    }

    public void setSource(String source) {
        this.source = System.getProperty("twitter4j.source", source);
        this.setRequestHeader("X-Twitter-Client", this.source);
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public void forceUsePost(boolean forceUsePost) {
    }

    public boolean isUsePostForced() {
        return false;
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }
}

