/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.DirectMessage;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends TwitterResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient"};
    private Twitter twitter;
    private int id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Date statusCreatedAt;
    private long statusId = -1L;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private long statusInReplyToStatusId = -1L;
    private int statusInReplyToUserId = -1;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private static final long serialVersionUID = 3037057798600246529L;

    User(Response res, Twitter twitter) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(elem, twitter);
    }

    User(Response res, Element elem, Twitter twitter) throws TwitterException {
        super(res);
        this.init(elem, twitter);
    }

    private void init(Element elem, Twitter twitter) throws TwitterException {
        this.twitter = twitter;
        User.ensureRootNodeNameIs(POSSIBLE_ROOT_NAMES, elem);
        this.id = User.getChildInt("id", elem);
        this.name = User.getChildText("name", elem);
        this.screenName = User.getChildText("screen_name", elem);
        this.location = User.getChildText("location", elem);
        this.description = User.getChildText("description", elem);
        this.profileImageUrl = User.getChildText("profile_image_url", elem);
        this.url = User.getChildText("url", elem);
        this.isProtected = User.getChildBoolean("protected", elem);
        this.followersCount = User.getChildInt("followers_count", elem);
        NodeList statuses = elem.getElementsByTagName("status");
        if (statuses.getLength() != 0) {
            Element status = (Element)statuses.item(0);
            this.statusCreatedAt = User.getChildDate("created_at", status);
            this.statusId = User.getChildLong("id", status);
            this.statusText = User.getChildText("text", status);
            this.statusSource = User.getChildText("source", status);
            this.statusTruncated = User.getChildBoolean("truncated", status);
            this.statusInReplyToStatusId = User.getChildLong("in_reply_to_status_id", status);
            this.statusInReplyToUserId = User.getChildInt("in_reply_to_user_id", status);
            this.statusFavorited = User.getChildBoolean("favorited", status);
            this.statusInReplyToScreenName = User.getChildText("in_reply_to_screen_name", status);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public DirectMessage sendDirectMessage(String text) throws TwitterException {
        return this.twitter.sendDirectMessage(this.getName(), text);
    }

    public static List<User> constructUsers(Response res, Twitter twitter) throws TwitterException {
        Document doc = res.asDocument();
        if (User.isRootNodeNilClasses(doc)) {
            return new ArrayList<User>(0);
        }
        try {
            User.ensureRootNodeNameIs("users", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("user");
            int size = list.getLength();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(res, (Element)list.item(i), twitter));
            }
            return users;
        }
        catch (TwitterException te) {
            if (User.isRootNodeNilClasses(doc)) {
                return new ArrayList<User>(0);
            }
            throw te;
        }
    }

    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    public long getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getStatusSource() {
        return this.statusSource;
    }

    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    public long getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    public int getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    public String getStatusInReplyToScreenName() {
        return -1 != this.statusInReplyToUserId ? this.statusInReplyToScreenName : null;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).id == this.id;
    }

    public String toString() {
        return new StringBuffer().append("User{twitter=").append(this.twitter).append(", id=").append(this.id).append(", name='").append(this.name).append('\'').append(", screenName='").append(this.screenName).append('\'').append(", location='").append(this.location).append('\'').append(", description='").append(this.description).append('\'').append(", profileImageUrl='").append(this.profileImageUrl).append('\'').append(", url='").append(this.url).append('\'').append(", isProtected=").append(this.isProtected).append(", followersCount=").append(this.followersCount).append(", statusCreatedAt=").append(this.statusCreatedAt).append(", statusId=").append(this.statusId).append(", statusText='").append(this.statusText).append('\'').append(", statusSource='").append(this.statusSource).append('\'').append(", statusTruncated=").append(this.statusTruncated).append(", statusInReplyToStatusId=").append(this.statusInReplyToStatusId).append(", statusInReplyToUserId=").append(this.statusInReplyToUserId).append(", statusFavorited=").append(this.statusFavorited).append(", statusInReplyToScreenName='").append(this.statusInReplyToScreenName).append('\'').append('}').toString();
    }
}

