/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import twitter4j.DirectMessage;
import twitter4j.ExtendedUser;
import twitter4j.IDs;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.Trends;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.http.AccessToken;
import twitter4j.http.HttpClient;
import twitter4j.http.PostParameter;
import twitter4j.http.RequestToken;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
implements Serializable {
    protected HttpClient http = null;
    private String baseURL = "http://twitter.com/";
    private String searchBaseURL = "http://search.twitter.com/";
    private String source;
    private boolean usePostForcibly = false;
    private static final int MAX_COUNT = 200;
    private static final long serialVersionUID = -7550633067620779906L;
    static final String VERSION = "2.0.3";
    public static final Device IM = new Device("im");
    public static final Device SMS = new Device("sms");
    public static final Device NONE = new Device("none");
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Twitter() {
        this.http = new HttpClient();
        this.setUserAgent("twitter4j http://yusuke.homeip.net/twitter4j/ /2.0.3");
        this.setSource("Twitter4J");
        this.setClientVersion(VERSION);
        this.setClientURL("http://yusuke.homeip.net/twitter4j/en/twitter4j-2.0.3.xml");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.http.setRequestTokenURL("http://twitter.com/oauth/request_token");
        this.http.setAuthorizationURL("http://twitter.com/oauth/authorize");
        this.http.setAccessTokenURL("http://twitter.com/oauth/access_token");
        this.setUserId(null);
        this.setPassword(null);
    }

    public Twitter(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public Twitter(String id, String password) {
        this();
        this.setUserId(id);
        this.setPassword(password);
    }

    public Twitter(String id, String password, String baseURL) {
        this();
        this.setUserId(id);
        this.setPassword(password);
        this.baseURL = baseURL;
    }

    public void setUserAgent(String userAgent) {
        this.http.setUserAgent(System.getProperty("twitter4j.http.userAgent", userAgent));
    }

    public String getUserAgent() {
        return this.http.getUserAgent();
    }

    public void setClientVersion(String version) {
        this.setRequestHeader("X-Twitter-Client-Version", System.getProperty("twitter4j.clientVersion", version));
    }

    public String getClientVersion() {
        return this.http.getRequestHeader("X-Twitter-Client-Version");
    }

    public void setClientURL(String clientURL) {
        this.setRequestHeader("X-Twitter-Client-URL", System.getProperty("twitter4j.clientURL", clientURL));
    }

    public String getClientURL() {
        return this.http.getRequestHeader("X-Twitter-Client-URL");
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    public synchronized void setUserId(String userId) {
        this.http.setUserId(System.getProperty("twitter4j.user", userId));
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public synchronized void setPassword(String password) {
        this.http.setPassword(System.getProperty("twitter4j.password", password));
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.http.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.http.getOAuthRequestToken();
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.http.getOAuthAccessToken(token, tokenSecret);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.http.setOAuthAccessToken(accessToken);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    public void setHttpProxy(String proxyHost, int proxyPort) {
        this.http.setProxyHost(proxyHost);
        this.http.setProxyPort(proxyPort);
    }

    public void setHttpProxyAuth(String proxyUser, String proxyPass) {
        this.http.setProxyAuthUser(proxyUser);
        this.http.setProxyAuthPassword(proxyPass);
    }

    public void setHttpConnectionTimeout(int connectionTimeout) {
        this.http.setConnectionTimeout(connectionTimeout);
    }

    public void setHttpReadTimeout(int readTimeout) {
        this.http.setReadTimeout(readTimeout);
    }

    public void setSource(String source) {
        this.source = System.getProperty("twitter4j.source", source);
        this.setRequestHeader("X-Twitter-Client", this.source);
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public void forceUsePost(boolean forceUsePost) {
        this.usePostForcibly = forceUsePost;
    }

    public boolean isUsePostForced() {
        return this.usePostForcibly;
    }

    private Response get(String url, boolean authenticate) throws TwitterException {
        return this.get(url, null, authenticate);
    }

    protected Response get(String url, String name1, String value1, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1)}, authenticate);
    }

    protected Response get(String url, String name1, String value1, String name2, String value2, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)}, authenticate);
    }

    protected Response get(String url, PostParameter[] params, boolean authenticate) throws TwitterException {
        if (this.usePostForcibly) {
            if (null == params) {
                return this.http.post(url, new PostParameter[0], authenticate);
            }
            return this.http.post(url, params, authenticate);
        }
        if (null != params && params.length > 0) {
            url = new StringBuffer().append(url).append("?").append(HttpClient.encodeParameters(params)).toString();
        }
        return this.http.get(url, authenticate);
    }

    protected Response get(String url, PostParameter[] params, Paging paging, boolean authenticate) throws TwitterException {
        if (null != paging) {
            ArrayList<PostParameter> pagingParams = new ArrayList<PostParameter>(4);
            if (-1 != paging.getCount()) {
                pagingParams.add(new PostParameter("count", String.valueOf(paging.getCount())));
            }
            if (-1L != paging.getMaxId()) {
                pagingParams.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (-1L != paging.getSinceId()) {
                pagingParams.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                pagingParams.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1L != paging.getSinceId()) {
                if (-1 != url.indexOf("search")) {
                    pagingParams.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    pagingParams.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] newparams = null;
            PostParameter[] arrayPagingParams = pagingParams.toArray(new PostParameter[pagingParams.size()]);
            if (null != params) {
                newparams = new PostParameter[params.length + pagingParams.size()];
                System.arraycopy(params, 0, newparams, 0, params.length);
                System.arraycopy(arrayPagingParams, 0, newparams, params.length, pagingParams.size());
            } else if (0 != arrayPagingParams.length) {
                String encodedParams = HttpClient.encodeParameters(arrayPagingParams);
                url = -1 != url.indexOf("?") ? new StringBuffer().append(url).append("&").append(encodedParams).toString() : new StringBuffer().append(url).append("?").append(encodedParams).toString();
            }
            return this.get(url, newparams, authenticate);
        }
        return this.get(url, params, authenticate);
    }

    public QueryResult search(Query query) throws TwitterException {
        return new QueryResult(this.get(new StringBuffer().append(this.searchBaseURL).append("search.json").toString(), query.asPostParameters(), false), this);
    }

    public Trends getTrends() throws TwitterException {
        return Trends.constructTrends(this.get(new StringBuffer().append(this.searchBaseURL).append("trends.json").toString(), false));
    }

    public Trends getCurrentTrends() throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/current.json").toString(), false)).get(0);
    }

    public Trends getCurrentTrends(boolean excludeHashTags) throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/current.json").append(excludeHashTags ? "?exclude=hashtags" : "").toString(), false)).get(0);
    }

    public List<Trends> getDailyTrends() throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/daily.json").toString(), false));
    }

    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/daily.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString(), false));
    }

    private String toDateStr(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public List<Trends> getWeeklyTrends() throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/weekly.json").toString(), false));
    }

    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return Trends.constructTrendsList(this.get(new StringBuffer().append(this.searchBaseURL).append("trends/weekly.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString(), false));
    }

    public List<Status> getPublicTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml").toString(), false), this);
    }

    public List<Status> getPublicTimeline(int sinceID) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml").toString(), null, new Paging((long)sinceID), false), this);
    }

    public List<Status> getFriendsTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), true), this);
    }

    public List<Status> getFriendsTimelineByPage(int page) throws TwitterException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(int page) throws TwitterException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(long sinceId, int page) throws TwitterException {
        return this.getFriendsTimeline(new Paging(page).sinceId(sinceId));
    }

    public List<Status> getFriendsTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), true), this);
    }

    public List<Status> getFriendsTimelineByPage(String id, int page) throws TwitterException {
        return this.getFriendsTimeline(id, new Paging(page));
    }

    public List<Status> getFriendsTimeline(String id, int page) throws TwitterException {
        return this.getFriendsTimeline(id, new Paging(page));
    }

    public List<Status> getFriendsTimeline(long sinceId, String id, int page) throws TwitterException {
        return this.getFriendsTimeline(id, new Paging(page).sinceId(sinceId));
    }

    public List<Status> getFriendsTimeline(Paging paging) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), null, paging, true), this);
    }

    public List<Status> getFriendsTimeline(String id, Paging paging) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), null, paging, true), this);
    }

    public List<Status> getFriendsTimeline(Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "since", this.format.format(since), true), this);
    }

    public List<Status> getFriendsTimeline(long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "since_id", String.valueOf(sinceId), true), this);
    }

    public List<Status> getFriendsTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), true), this);
    }

    public List<Status> getFriendsTimeline(String id, long sinceId) throws TwitterException {
        return this.getFriendsTimeline(id, new Paging(sinceId));
    }

    public List<Status> getUserTimeline(String id, int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), "count", String.valueOf(count), true), this);
    }

    public List<Status> getUserTimeline(String id, int count, long sinceId) throws TwitterException {
        return this.getUserTimeline(id, new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id, Paging paging) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), null, paging, true), this);
    }

    public List<Status> getUserTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), true), this);
    }

    public List<Status> getUserTimeline(String id, int count) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "count", String.valueOf(count), true), this);
    }

    public List<Status> getUserTimeline(int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), "since", this.format.format(since), "count", String.valueOf(count), true), this);
    }

    public List<Status> getUserTimeline(int count, long sinceId) throws TwitterException {
        return this.getUserTimeline(new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), true), this);
    }

    public List<Status> getUserTimeline(String id, long sinceId) throws TwitterException {
        return this.getUserTimeline(id, new Paging(sinceId));
    }

    public List<Status> getUserTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), true), this);
    }

    public List<Status> getUserTimeline(Paging paging) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), null, paging, true), this);
    }

    public List<Status> getUserTimeline(long sinceId) throws TwitterException {
        return this.getUserTimeline(new Paging(sinceId));
    }

    public List<Status> getReplies() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), true), this);
    }

    public List<Status> getReplies(long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "since_id", String.valueOf(sinceId), true), this);
    }

    public List<Status> getRepliesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "page", String.valueOf(page), true), this);
    }

    public List<Status> getReplies(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "page", String.valueOf(page), true), this);
    }

    public List<Status> getReplies(long sinceId, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "since_id", String.valueOf(sinceId), "page", String.valueOf(page), true), this);
    }

    public List<Status> getMentions() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/mentions.xml").toString(), null, true), this);
    }

    public List<Status> getMentions(Paging paging) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/mentions.xml").toString(), null, paging, true), this);
    }

    public Status show(int id) throws TwitterException {
        return this.showStatus(id);
    }

    public Status show(long id) throws TwitterException {
        return new Status(this.get(new StringBuffer().append(this.baseURL).append("statuses/show/").append(id).append(".xml").toString(), false), this);
    }

    public Status showStatus(long id) throws TwitterException {
        return new Status(this.get(new StringBuffer().append(this.baseURL).append("statuses/show/").append(id).append(".xml").toString(), false), this);
    }

    public Status update(String status) throws TwitterException {
        return this.updateStatus(status);
    }

    public Status updateStatus(String status) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/update.xml").toString(), new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, true), this);
    }

    public Status update(String status, long inReplyToStatusId) throws TwitterException {
        return this.updateStatus(status, inReplyToStatusId);
    }

    public Status updateStatus(String status, long inReplyToStatusId) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/update.xml").toString(), new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true), this);
    }

    public Status destroyStatus(long statusId) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/destroy/").append(statusId).append(".xml").toString(), new PostParameter[0], true), this);
    }

    public ExtendedUser getUserDetail(String id) throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("users/show/").append(id).append(".xml").toString(), true), this);
    }

    public List<User> getFriends() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml").toString(), true), this);
    }

    public List<User> getFriends(Paging paging) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml").toString(), null, paging, true), this);
    }

    public List<User> getFriends(int page) throws TwitterException {
        return this.getFriends(new Paging(page));
    }

    public List<User> getFriends(String id) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends/").append(id).append(".xml").toString(), true), this);
    }

    public List<User> getFriends(String id, Paging paging) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends/").append(id).append(".xml").toString(), null, paging, true), this);
    }

    public List<User> getFriends(String id, int page) throws TwitterException {
        return this.getFriends(id, new Paging(page));
    }

    public List<User> getFollowers() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers.xml").toString(), true), this);
    }

    public List<User> getFollowers(Paging paging) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers.xml").toString(), null, paging, true), this);
    }

    public List<User> getFollowers(int page) throws TwitterException {
        return this.getFollowers(new Paging(page));
    }

    public List<User> getFollowers(String id) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers/").append(id).append(".xml").toString(), true), this);
    }

    public List<User> getFollowers(String id, Paging paging) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers/").append(id).append(".xml").toString(), null, paging, true), this);
    }

    public List<User> getFollowers(String id, int page) throws TwitterException {
        return this.getFollowers(id, new Paging(page));
    }

    public List<User> getFeatured() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/featured.xml").toString(), true), this);
    }

    public List<DirectMessage> getDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), true), this);
    }

    public List<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), null, paging, true), this);
    }

    public List<DirectMessage> getDirectMessagesByPage(int page) throws TwitterException {
        return this.getDirectMessages(new Paging(page));
    }

    public List<DirectMessage> getDirectMessages(int page, int sinceId) throws TwitterException {
        return this.getDirectMessages(new Paging(page).sinceId(sinceId));
    }

    public List<DirectMessage> getDirectMessages(int sinceId) throws TwitterException {
        return this.getDirectMessages(new Paging((long)sinceId));
    }

    public List<DirectMessage> getDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), "since", this.format.format(since), true), this);
    }

    public List<DirectMessage> getSentDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), new PostParameter[0], true), this);
    }

    public List<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), new PostParameter[0], paging, true), this);
    }

    public List<DirectMessage> getSentDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), "since", this.format.format(since), true), this);
    }

    public List<DirectMessage> getSentDirectMessages(int sinceId) throws TwitterException {
        return this.getSentDirectMessages(new Paging((long)sinceId));
    }

    public List<DirectMessage> getSentDirectMessages(int page, int sinceId) throws TwitterException {
        return this.getSentDirectMessages(new Paging(page, (long)sinceId));
    }

    public DirectMessage sendDirectMessage(String id, String text) throws TwitterException {
        return new DirectMessage(this.http.post(new StringBuffer().append(this.baseURL).append("direct_messages/new.xml").toString(), new PostParameter[]{new PostParameter("user", id), new PostParameter("text", text)}, true), this);
    }

    public DirectMessage deleteDirectMessage(int id) throws TwitterException {
        return this.destroyDirectMessage(id);
    }

    public DirectMessage destroyDirectMessage(int id) throws TwitterException {
        return new DirectMessage(this.http.post(new StringBuffer().append(this.baseURL).append("direct_messages/destroy/").append(id).append(".xml").toString(), new PostParameter[0], true), this);
    }

    public User create(String id) throws TwitterException {
        return this.createFriendship(id);
    }

    public User createFriendship(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("friendships/create/").append(id).append(".xml").toString(), new PostParameter[0], true), this);
    }

    public User createFriendship(String id, boolean follow) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("friendships/create/").append(id).append(".xml").toString(), new PostParameter[]{new PostParameter("follow", String.valueOf(follow))}, true), this);
    }

    public User destroy(String id) throws TwitterException {
        return this.destroyFriendship(id);
    }

    public User destroyFriendship(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("friendships/destroy/").append(id).append(".xml").toString(), new PostParameter[0], true), this);
    }

    public boolean exists(String userA, String userB) throws TwitterException {
        return this.existsFriendship(userA, userB);
    }

    public boolean existsFriendship(String userA, String userB) throws TwitterException {
        return -1 != this.get(new StringBuffer().append(this.baseURL).append("friendships/exists.xml").toString(), "user_a", userA, "user_b", userB, true).asString().indexOf("true");
    }

    public IDs getFriendsIDs() throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml").toString(), true));
    }

    public IDs getFriendsIDs(Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml").toString(), null, paging, true));
    }

    public IDs getFriendsIDs(int userId) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?user_id=").append(userId).toString(), true));
    }

    public IDs getFriendsIDs(int userId, Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?user_id=").append(userId).toString(), null, paging, true));
    }

    public IDs getFriendsIDs(String screenName) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?screen_name=").append(screenName).toString(), true));
    }

    public IDs getFriendsIDs(String screenName, Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?screen_name=").append(screenName).toString(), null, paging, true));
    }

    public IDs getFollowersIDs() throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml").toString(), true));
    }

    public IDs getFollowersIDs(Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml").toString(), null, paging, true));
    }

    public IDs getFollowersIDs(int userId) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?user_id=").append(userId).toString(), true));
    }

    public IDs getFollowersIDs(int userId, Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?user_id=").append(userId).toString(), null, paging, true));
    }

    public IDs getFollowersIDs(String screenName) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?screen_name=").append(screenName).toString(), true));
    }

    public IDs getFollowersIDs(String screenName, Paging paging) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?screen_name=").append(screenName).toString(), null, paging, true));
    }

    public ExtendedUser verifyCredentials() throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("account/verify_credentials.xml").toString(), true), this);
    }

    public User updateLocation(String location) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_location.xml").toString(), new PostParameter[]{new PostParameter("location", location)}, true), this);
    }

    public ExtendedUser updateProfile(String name, String email, String url, String location, String description) throws TwitterException {
        ArrayList<PostParameter> profile = new ArrayList<PostParameter>(5);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "email", email);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return new ExtendedUser(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_profile.xml").toString(), profile.toArray(new PostParameter[profile.size()]), true), this);
    }

    public RateLimitStatus rateLimitStatus() throws TwitterException {
        return new RateLimitStatus(this.http.get(new StringBuffer().append(this.baseURL).append("account/rate_limit_status.xml").toString(), null != this.getUserId() && null != this.getPassword()));
    }

    public User updateDeliverlyDevice(Device device) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_delivery_device.xml").toString(), new PostParameter[]{new PostParameter("device", device.DEVICE)}, true), this);
    }

    public ExtendedUser updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        ArrayList<PostParameter> colors = new ArrayList<PostParameter>(5);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        return new ExtendedUser(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_profile_colors.xml").toString(), colors.toArray(new PostParameter[colors.size()]), true), this);
    }

    private void addParameterToList(List<PostParameter> colors, String paramName, String color) {
        if (null != color) {
            colors.add(new PostParameter(paramName, color));
        }
    }

    public List<Status> favorites() throws TwitterException {
        return this.getFavorites();
    }

    public List<Status> getFavorites() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites.xml").toString(), new PostParameter[0], true), this);
    }

    public List<Status> favorites(int page) throws TwitterException {
        return this.getFavorites(page);
    }

    public List<Status> getFavorites(int page) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites.xml").toString(), "page", String.valueOf(page), true), this);
    }

    public List<Status> favorites(String id) throws TwitterException {
        return this.getFavorites(id);
    }

    public List<Status> getFavorites(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml").toString(), new PostParameter[0], true), this);
    }

    public List<Status> favorites(String id, int page) throws TwitterException {
        return this.getFavorites(id, page);
    }

    public List<Status> getFavorites(String id, int page) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml").toString(), "page", String.valueOf(page), true), this);
    }

    public Status createFavorite(long id) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("favorites/create/").append(id).append(".xml").toString(), true), this);
    }

    public Status destroyFavorite(long id) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("favorites/destroy/").append(id).append(".xml").toString(), true), this);
    }

    public User follow(String id) throws TwitterException {
        return this.enableNotification(id);
    }

    public User enableNotification(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("notifications/follow/").append(id).append(".xml").toString(), true), this);
    }

    public User leave(String id) throws TwitterException {
        return this.disableNotification(id);
    }

    public User disableNotification(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("notifications/leave/").append(id).append(".xml").toString(), true), this);
    }

    public User block(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/create/").append(id).append(".xml").toString(), true), this);
    }

    public User createBlock(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/create/").append(id).append(".xml").toString(), true), this);
    }

    public User unblock(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/destroy/").append(id).append(".xml").toString(), true), this);
    }

    public User destroyBlock(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/destroy/").append(id).append(".xml").toString(), true), this);
    }

    public boolean test() throws TwitterException {
        return -1 != this.get(new StringBuffer().append(this.baseURL).append("help/test.xml").toString(), false).asString().indexOf("ok");
    }

    public ExtendedUser getAuthenticatedUser() throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("account/verify_credentials.xml").toString(), true), this);
    }

    public String getDowntimeSchedule() throws TwitterException {
        throw new TwitterException("this method is not supported by the Twitter API anymore", new NoSuchMethodException("this method is not supported by the Twitter API anymore"));
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Twitter twitter = (Twitter)o;
        if (this.usePostForcibly != twitter.usePostForcibly) {
            return false;
        }
        if (!this.baseURL.equals(twitter.baseURL)) {
            return false;
        }
        if (!this.format.equals(twitter.format)) {
            return false;
        }
        if (!this.http.equals(twitter.http)) {
            return false;
        }
        if (!this.searchBaseURL.equals(twitter.searchBaseURL)) {
            return false;
        }
        return this.source.equals(twitter.source);
    }

    public int hashCode() {
        int result = this.http.hashCode();
        result = 31 * result + this.baseURL.hashCode();
        result = 31 * result + this.searchBaseURL.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (this.usePostForcibly ? 1 : 0);
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        return new StringBuffer().append("Twitter{http=").append(this.http).append(", baseURL='").append(this.baseURL).append('\'').append(", searchBaseURL='").append(this.searchBaseURL).append('\'').append(", source='").append(this.source).append('\'').append(", usePostForcibly=").append(this.usePostForcibly).append(", format=").append(this.format).append('}').toString();
    }

    static class Device {
        final String DEVICE;

        public Device(String device) {
            this.DEVICE = device;
        }
    }
}

