/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends TwitterResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Status(Response res, Twitter twitter) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, twitter);
    }

    Status(Response res, Element elem, Twitter twitter) throws TwitterException {
        super(res);
        this.init(res, elem, twitter);
    }

    private void init(Response res, Element elem, Twitter twitter) throws TwitterException {
        Status.ensureRootNodeNameIs("status", elem);
        this.user = new User(res, (Element)elem.getElementsByTagName("user").item(0), twitter);
        this.id = Status.getChildLong("id", elem);
        this.text = Status.getChildText("text", elem);
        this.source = Status.getChildText("source", elem);
        this.createdAt = Status.getChildDate("created_at", elem);
        this.isTruncated = Status.getChildBoolean("truncated", elem);
        this.inReplyToStatusId = Status.getChildInt("in_reply_to_status_id", elem);
        this.inReplyToUserId = Status.getChildInt("in_reply_to_user_id", elem);
        this.isFavorited = Status.getChildBoolean("favorited", elem);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    static List<Status> constructStatuses(Response res, Twitter twitter) throws TwitterException {
        Document doc = res.asDocument();
        if (Status.isRootNodeNilClasses(doc)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(res, status, twitter));
            }
            return statuses;
        }
        catch (TwitterException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Status>(0);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).id == this.id;
    }

    public String toString() {
        return new StringBuffer().append("Status{createdAt=").append(this.createdAt).append(", id=").append(this.id).append(", text='").append(this.text).append('\'').append(", source='").append(this.source).append('\'').append(", isTruncated=").append(this.isTruncated).append(", inReplyToStatusId=").append(this.inReplyToStatusId).append(", inReplyToUserId=").append(this.inReplyToUserId).append(", isFavorited=").append(this.isFavorited).append(", user=").append(this.user).append('}').toString();
    }
}

