/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import twitter4j.TwitterException;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

public class Response
implements Serializable {
    static DocumentBuilder builder = null;
    private int statusCode;
    private Document response = null;
    private String responseString = null;
    private InputStream is;
    private SAXException saxe = null;
    private HttpURLConnection con;
    private static final long serialVersionUID = -8868373803067492270L;

    public Response(HttpURLConnection con) throws IOException {
        this.statusCode = con.getResponseCode();
        BufferedReader br = null;
        InputStream is = null;
        is = this.statusCode == 200 ? con.getInputStream() : con.getErrorStream();
        if ("gzip".equals(con.getContentEncoding())) {
            is = new GZIPInputStream(is);
        }
        this.con = con;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer buf = new StringBuffer();
            while (null != (line = br.readLine())) {
                buf.append(line).append("\n");
            }
            this.responseString = buf.toString();
            this.is = new ByteArrayInputStream(this.responseString.getBytes("UTF-8"));
        }
        catch (NullPointerException ignore) {
            throw new IOException(ignore.getMessage());
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public String asString() {
        return this.responseString;
    }

    public InputStream asStream() {
        return this.is;
    }

    public Document asDocument() throws TwitterException {
        if (null == this.saxe && null == this.response) {
            try {
                this.response = builder.parse(new ByteArrayInputStream(this.responseString.getBytes("UTF-8")));
            }
            catch (SAXException saxe) {
                this.saxe = saxe;
            }
            catch (IOException ioe) {
                throw new TwitterException("Twitter returned a non-XML response", ioe);
            }
        }
        if (null != this.saxe) {
            throw new TwitterException("Twitter returned a non-XML response:" + this.responseString, this.saxe);
        }
        return this.response;
    }

    public JSONObject asJSONObject() throws TwitterException {
        try {
            return new JSONObject(this.responseString);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + this.responseString);
        }
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    public String toString() {
        return this.responseString;
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

