/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import org.w3c.dom.Element;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;

public class RateLimitStatus
extends TwitterResponse {
    private int remainingHits;
    private int hourlyLimit;
    private int resetTimeInSeconds;
    private Date dateTime;
    private static final long serialVersionUID = -2326597301406666858L;

    RateLimitStatus(Response res) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.remainingHits = this.getChildInt("remaining-hits", elem);
        this.hourlyLimit = this.getChildInt("hourly-limit", elem);
        this.resetTimeInSeconds = this.getChildInt("reset-time-in-seconds", elem);
        this.dateTime = this.getChildDate("reset-time", elem, "yyyy-M-d'T'HH:mm:ss+00:00");
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getDateTime() {
        return this.dateTime;
    }
}

