/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.http.Response;

abstract class OAuthToken
implements Serializable {
    private String token;
    private String tokenSecret;
    private transient SecretKeySpec secretKeySpec;

    public OAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    OAuthToken(Response response) {
        String[] responseStr;
        String[] arr$ = responseStr = response.asString().split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String str = arr$[i$];
            if (str.startsWith("oauth_token_secret")) {
                this.tokenSecret = str.split("=")[1].trim();
                continue;
            }
            this.token = str.split("=")[1].trim();
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken that = (OAuthToken)o;
        if (this.secretKeySpec != null ? !this.secretKeySpec.equals(that.secretKeySpec) : that.secretKeySpec != null) {
            return false;
        }
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.tokenSecret.equals(that.tokenSecret);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.tokenSecret.hashCode();
        result = 31 * result + (this.secretKeySpec != null ? this.secretKeySpec.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

