/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.http.OAuthToken;
import twitter4j.http.RequestToken;

public class OAuthUpdate {
    public static void main(String[] args) {
        try {
            Twitter twitter = new Twitter();
            RequestToken requestToken = twitter.getOAuthRequestToken();
            System.out.println("Got request token.");
            System.out.println("Request token: " + requestToken.getToken());
            System.out.println("Request token secret: " + requestToken.getTokenSecret());
            OAuthToken accessToken = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (null == accessToken) {
                System.out.println("Open the following URL and grant access to your account:");
                System.out.println(requestToken.getAuthorizationURL());
                System.out.print("Hit enter when it's done.[Enter]:");
                br.readLine();
                try {
                    accessToken = requestToken.getAccessToken();
                }
                catch (TwitterException te) {
                    if (401 == te.getStatusCode()) {
                        System.out.println("Unable to get the access token.");
                        continue;
                    }
                    te.printStackTrace();
                }
            }
            System.out.println("Got access token.");
            System.out.println("Access token: " + accessToken.getToken());
            System.out.println("Access token secret: " + accessToken.getTokenSecret());
            Status status = twitter.update(args[0]);
            System.out.println("Successfully updated the status to [" + status.getText() + "].");
            System.exit(0);
        }
        catch (TwitterException te) {
            System.out.println("Failed to get timeline: " + te.getMessage());
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("Failed to read the system input.");
            System.exit(-1);
        }
    }
}

