/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

public class Tweet
extends TwitterResponse {
    private String text;
    private int toUserId = -1;
    private String toUser = null;
    private String fromUser;
    private long id;
    private int fromUserId;
    private String isoLanguageCode = null;
    private String source;
    private String profileImageUrl;
    private Date createdAt;
    private static final long serialVersionUID = 4299736733993211587L;

    Tweet(JSONObject tweet, Twitter twitter) throws TwitterException {
        try {
            this.text = this.getString("text", tweet);
            try {
                this.toUserId = tweet.getInt("to_user_id");
                this.toUser = tweet.getString("to_user");
            }
            catch (JSONException ignore) {
                // empty catch block
            }
            this.fromUser = tweet.getString("from_user");
            this.id = tweet.getLong("id");
            this.fromUserId = tweet.getInt("from_user_id");
            try {
                this.isoLanguageCode = tweet.getString("iso_language_code");
            }
            catch (JSONException ignore) {
                // empty catch block
            }
            this.source = this.getString("source", tweet);
            this.profileImageUrl = this.getString("profile_image_url", tweet);
            this.createdAt = this.encodeDate(tweet.getString("created_at"), "EEE, dd MMM yyyy HH:mm:ss z");
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage());
        }
    }

    public String getText() {
        return this.text;
    }

    public int getToUserId() {
        return this.toUserId;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public long getId() {
        return this.id;
    }

    public int getFromUserId() {
        return this.fromUserId;
    }

    public String getIsoLanguageCode() {
        return this.isoLanguageCode;
    }

    public String getSource() {
        return this.source;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tweet that = (Tweet)o;
        if (this.fromUserId != that.fromUserId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.toUserId != that.toUserId) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.fromUser != null ? !this.fromUser.equals(that.fromUser) : that.fromUser != null) {
            return false;
        }
        if (this.isoLanguageCode != null ? !this.isoLanguageCode.equals(that.isoLanguageCode) : that.isoLanguageCode != null) {
            return false;
        }
        if (this.profileImageUrl != null ? !this.profileImageUrl.equals(that.profileImageUrl) : that.profileImageUrl != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return !(this.toUser != null ? !this.toUser.equals(that.toUser) : that.toUser != null);
    }

    public int hashCode() {
        int result = this.text != null ? this.text.hashCode() : 0;
        result = 31 * result + (this.toUserId ^ this.toUserId >>> 32);
        result = 31 * result + (this.toUser != null ? this.toUser.hashCode() : 0);
        result = 31 * result + (this.fromUser != null ? this.fromUser.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.fromUserId ^ this.fromUserId >>> 32);
        result = 31 * result + (this.isoLanguageCode != null ? this.isoLanguageCode.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.profileImageUrl != null ? this.profileImageUrl.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Tweet{text='" + this.text + '\'' + ", toUserId=" + this.toUserId + ", toUser='" + this.toUser + '\'' + ", fromUser='" + this.fromUser + '\'' + ", id=" + this.id + ", fromUserId=" + this.fromUserId + ", isoLanguageCode='" + this.isoLanguageCode + '\'' + ", source='" + this.source + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", createdAt=" + this.createdAt + '}';
    }
}

