/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import org.w3c.dom.Element;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.UserWithStatus;

public class ExtendedUser
extends UserWithStatus {
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundTile;
    private boolean following;
    private boolean notificationEnabled;
    private int statusesCount;
    private static final long serialVersionUID = -8486230870587454252L;

    public ExtendedUser(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.profileBackgroundColor = this.getChildText("profile_background_color", elem);
        this.profileTextColor = this.getChildText("profile_text_color", elem);
        this.profileLinkColor = this.getChildText("profile_link_color", elem);
        this.profileSidebarFillColor = this.getChildText("profile_sidebar_fill_color", elem);
        this.profileSidebarBorderColor = this.getChildText("profile_sidebar_border_color", elem);
        this.friendsCount = this.getChildInt("friends_count", elem);
        this.createdAt = this.getChildDate("created_at", elem);
        this.favouritesCount = this.getChildInt("favourites_count", elem);
        this.utcOffset = this.getChildInt("utc_offset", elem);
        this.timeZone = this.getChildText("time_zone", elem);
        this.profileBackgroundImageUrl = this.getChildText("profile_background_image_url", elem);
        this.profileBackgroundTile = this.getChildText("profile_background_tile", elem);
        this.following = this.getChildBoolean("following", elem);
        this.notificationEnabled = this.getChildBoolean("notifications", elem);
        this.statusesCount = this.getChildInt("statuses_count", elem);
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public boolean isNotifications() {
        return this.notificationEnabled;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedUser that = (ExtendedUser)o;
        if (this.favouritesCount != that.favouritesCount) {
            return false;
        }
        if (this.following != that.following) {
            return false;
        }
        if (this.friendsCount != that.friendsCount) {
            return false;
        }
        if (this.notificationEnabled != that.notificationEnabled) {
            return false;
        }
        if (this.statusesCount != that.statusesCount) {
            return false;
        }
        if (this.utcOffset != that.utcOffset) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.profileBackgroundColor != null ? !this.profileBackgroundColor.equals(that.profileBackgroundColor) : that.profileBackgroundColor != null) {
            return false;
        }
        if (this.profileBackgroundImageUrl != null ? !this.profileBackgroundImageUrl.equals(that.profileBackgroundImageUrl) : that.profileBackgroundImageUrl != null) {
            return false;
        }
        if (this.profileBackgroundTile != null ? !this.profileBackgroundTile.equals(that.profileBackgroundTile) : that.profileBackgroundTile != null) {
            return false;
        }
        if (this.profileLinkColor != null ? !this.profileLinkColor.equals(that.profileLinkColor) : that.profileLinkColor != null) {
            return false;
        }
        if (this.profileSidebarBorderColor != null ? !this.profileSidebarBorderColor.equals(that.profileSidebarBorderColor) : that.profileSidebarBorderColor != null) {
            return false;
        }
        if (this.profileSidebarFillColor != null ? !this.profileSidebarFillColor.equals(that.profileSidebarFillColor) : that.profileSidebarFillColor != null) {
            return false;
        }
        if (this.profileTextColor != null ? !this.profileTextColor.equals(that.profileTextColor) : that.profileTextColor != null) {
            return false;
        }
        return !(this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.profileBackgroundColor != null ? this.profileBackgroundColor.hashCode() : 0);
        result = 31 * result + (this.profileTextColor != null ? this.profileTextColor.hashCode() : 0);
        result = 31 * result + (this.profileLinkColor != null ? this.profileLinkColor.hashCode() : 0);
        result = 31 * result + (this.profileSidebarFillColor != null ? this.profileSidebarFillColor.hashCode() : 0);
        result = 31 * result + (this.profileSidebarBorderColor != null ? this.profileSidebarBorderColor.hashCode() : 0);
        result = 31 * result + this.friendsCount;
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + this.favouritesCount;
        result = 31 * result + this.utcOffset;
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.profileBackgroundImageUrl != null ? this.profileBackgroundImageUrl.hashCode() : 0);
        result = 31 * result + (this.profileBackgroundTile != null ? this.profileBackgroundTile.hashCode() : 0);
        result = 31 * result + (this.following ? 1 : 0);
        result = 31 * result + (this.notificationEnabled ? 1 : 0);
        result = 31 * result + this.statusesCount;
        return result;
    }

    public String toString() {
        return "ExtendedUser{profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundTile='" + this.profileBackgroundTile + '\'' + ", following=" + this.following + ", notifications=" + this.notificationEnabled + ", statusesCount=" + this.statusesCount + '}';
    }
}

