/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import twitter4j.TwitterException;
import twitter4j.http.AccessToken;
import twitter4j.http.BASE64Encoder;
import twitter4j.http.OAuth;
import twitter4j.http.OAuthToken;
import twitter4j.http.PostParameter;
import twitter4j.http.RequestToken;
import twitter4j.http.Response;

public class HttpClient
implements Serializable {
    private final int OK = 200;
    private final int NOT_MODIFIED = 304;
    private final int UNAUTHORIZED = 401;
    private final int FORBIDDEN = 403;
    private final boolean DEBUG = Boolean.getBoolean("twitter4j.debug");
    private final int INTERNAL_SERVER_ERROR = 500;
    private String basic = null;
    private int retryCount = 0;
    private int retryIntervalMillis = 10000;
    private String userId = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyAuthUser = null;
    private String proxyAuthPassword = null;
    private int connectionTimeout = 0;
    private int readTimeout = 0;
    private static final long serialVersionUID = 808018030183407996L;
    private boolean isJDK14orEarlier = false;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private OAuth oauth = null;
    private String requestTokenURL = "http://twitter.com/oauth/request_token";
    private String authorizationURL = "http://twitter.com/oauth/authorize";
    private String accessTokenURL = "http://twitter.com/oauth/access_token";
    private OAuthToken oauthToken = null;
    int retriedCount = 0;
    String lastURL;

    public HttpClient(String userId, String password) {
        this();
        this.setUserId(userId);
        this.setPassword(password);
    }

    public HttpClient() {
        this.setProxyPort(0);
        this.setProxyHost(null);
        this.setConnectionTimeout(10000);
        this.setReadTimeout(30000);
        this.setProxyAuthUser(null);
        this.setProxyAuthPassword(null);
        this.setUserId(null);
        this.setPassword(null);
        this.setOAuthConsumer(null, null);
        String versionStr = System.getProperty("java.specification.version");
        if (null != versionStr) {
            this.isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
        }
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.encodeBasicAuthenticationString();
    }

    public void setPassword(String password) {
        this.password = password;
        this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationEnabled() {
        return null != this.basic || null != this.oauth;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        consumerKey = System.getProperty("twitter4j.oauth.consumerKey", consumerKey);
        consumerSecret = System.getProperty("twitter4j.oauth.consumerSecret", consumerSecret);
        if (null != consumerKey && null != consumerSecret && 0 != consumerKey.length() && 0 != consumerSecret.length()) {
            this.oauth = new OAuth(consumerKey, consumerSecret);
        }
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, new PostParameter[0], true), this);
        return (RequestToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken token) throws TwitterException {
        try {
            this.oauthToken = token;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (TwitterException te) {
            throw new TwitterException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public void setOAuthAccessToken(AccessToken token) {
        this.oauthToken = token;
    }

    public void setRequestTokenURL(String requestTokenURL) {
        this.requestTokenURL = requestTokenURL;
    }

    public String getRequestTokenURL() {
        return this.requestTokenURL;
    }

    public void setAuthorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public void setAccessTokenURL(String accessTokenURL) {
        this.accessTokenURL = accessTokenURL;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = System.getProperty("twitter4j.http.proxyHost", System.getProperty("http.proxyHost", proxyHost));
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        try {
            this.proxyPort = Integer.parseInt(System.getProperty("twitter4j.http.proxyPort", System.getProperty("http.proxyPort", String.valueOf(proxyPort))));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = System.getProperty("twitter4j.http.proxyUser", proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = System.getProperty("twitter4j.http.proxyPassword", proxyAuthPassword);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        try {
            this.connectionTimeout = Integer.parseInt(System.getProperty("twitter4j.http.connectionTimeout", String.valueOf(connectionTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        try {
            this.readTimeout = Integer.parseInt(System.getProperty("twitter4j.http.readTimeout", String.valueOf(readTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void encodeBasicAuthenticationString() {
        if (null != this.userId && null != this.password) {
            this.basic = "Basic " + new String(new BASE64Encoder().encode((this.userId + ":" + this.password).getBytes()));
        }
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = retryCount;
    }

    public void setUserAgent(String ua) {
        this.setRequestHeader("User-Agent", ua);
    }

    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        if (retryIntervalSecs < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalMillis = retryIntervalSecs * 1000;
    }

    public Response post(String url, PostParameter[] postParameters, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, postParameters, authenticated);
    }

    public Response post(String url, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, new PostParameter[0], authenticated);
    }

    public Response post(String url, PostParameter[] PostParameters) throws TwitterException {
        return this.httpRequest(url, PostParameters, false);
    }

    public Response post(String url) throws TwitterException {
        return this.httpRequest(url, new PostParameter[0], false);
    }

    public Response get(String url, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, null, authenticated);
    }

    public Response get(String url) throws TwitterException {
        return this.httpRequest(url, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response httpRequest(String url, PostParameter[] postParams, boolean authenticated) throws TwitterException {
        int retry = this.retryCount + 1;
        Response res = null;
        this.lastURL = url;
        this.retriedCount = 0;
        while (this.retriedCount < retry) {
            int responseCode = -1;
            try {
                HttpURLConnection con = null;
                InputStream is = null;
                OutputStream osw = null;
                try {
                    con = this.getConnection(url);
                    con.setDoInput(true);
                    this.setHeaders(url, postParams, con, authenticated);
                    if (null != postParams) {
                        this.log("POST ", url);
                        con.setRequestMethod("POST");
                        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        con.setDoOutput(true);
                        String postParam = HttpClient.encodeParameters(postParams);
                        this.log("Post Params: ", postParam);
                        byte[] bytes = postParam.getBytes("UTF-8");
                        con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                        osw = con.getOutputStream();
                        osw.write(bytes);
                        osw.flush();
                        osw.close();
                    } else {
                        this.log("GET " + url);
                        con.setRequestMethod("GET");
                    }
                    responseCode = con.getResponseCode();
                    this.log("Response code: ", String.valueOf(responseCode));
                    is = responseCode == 401 || responseCode == 403 ? con.getErrorStream() : con.getInputStream();
                    res = new Response(con.getResponseCode(), is);
                    this.log("Response: ", res.toString());
                    if (responseCode == 401 || responseCode == 403) {
                        throw new TwitterException(res.toString(), responseCode);
                    }
                    break;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ignore) {}
                    try {
                        osw.close();
                    }
                    catch (Exception ignore) {}
                    try {
                        con.disconnect();
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (IOException ioe) {
                if (responseCode == 401 || responseCode == 403) {
                    if (this.DEBUG) {
                        ioe.printStackTrace();
                    }
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
                if (this.retriedCount == this.retryCount) {
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
                try {
                    Thread.sleep(this.retryIntervalMillis);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                ++this.retriedCount;
            }
        }
        return res;
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < postParams.length; ++j) {
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(postParams[j].name).append("=").append(URLEncoder.encode(postParams[j].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    private void setHeaders(String url, PostParameter[] params, HttpURLConnection connection, boolean authenticated) {
        this.log("Request Headers: ");
        if (authenticated) {
            if (this.basic != null || this.oauth == null) {
                // empty if block
            }
            String authorization = null;
            if (null != this.oauth) {
                authorization = this.oauth.generateAuthorizationHeader(params != null ? "POST" : "GET", url, params, this.oauthToken);
            } else if (null != this.basic) {
                authorization = this.basic;
            } else {
                throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
            }
            connection.addRequestProperty("Authorization", authorization);
            this.log("Authorization: " + authorization);
        }
        Iterator<String> i$ = this.requestHeaders.keySet().iterator();
        while (i$.hasNext()) {
            String key = i$.next();
            connection.addRequestProperty(key, this.requestHeaders.get(key));
            this.log(key + ": " + this.requestHeaders.get(key));
        }
    }

    public void setRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con = null;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                this.log("Proxy AuthUser: " + this.proxyAuthUser);
                this.log("Proxy AuthPassword: " + this.proxyAuthPassword);
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.proxyAuthUser, HttpClient.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (this.DEBUG) {
                this.log("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.connectionTimeout > 0 && !this.isJDK14orEarlier) {
            con.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !this.isJDK14orEarlier) {
            con.setReadTimeout(this.readTimeout);
        }
        return con;
    }

    public int hashCode() {
        int result = 200;
        result = 31 * result + 304;
        result = 31 * result + 401;
        result = 31 * result + 403;
        result = 31 * result + (this.DEBUG ? 1 : 0);
        result = 31 * result + 500;
        result = 31 * result + (this.basic != null ? this.basic.hashCode() : 0);
        result = 31 * result + this.retryCount;
        result = 31 * result + this.retryIntervalMillis;
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.proxyAuthUser != null ? this.proxyAuthUser.hashCode() : 0);
        result = 31 * result + (this.proxyAuthPassword != null ? this.proxyAuthPassword.hashCode() : 0);
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.isJDK14orEarlier ? 1 : 0);
        result = 31 * result + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        result = 31 * result + this.retriedCount;
        result = 31 * result + (this.lastURL != null ? this.lastURL.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpClient) {
            HttpClient that = (HttpClient)obj;
            return this.retryCount == that.retriedCount && this.retryIntervalMillis == that.retryIntervalMillis && this.basic.equals(that.basic) && ((Object)this.requestHeaders).equals(that.requestHeaders);
        }
        return false;
    }

    private void log(String message) {
        if (this.DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private void log(String message, String message2) {
        if (this.DEBUG) {
            this.log(message + message2);
        }
    }
}

