/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import twitter4j.DirectMessage;
import twitter4j.ExtendedUser;
import twitter4j.IDs;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.http.AccessToken;
import twitter4j.http.HttpClient;
import twitter4j.http.PostParameter;
import twitter4j.http.RequestToken;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
implements Serializable {
    protected HttpClient http = null;
    private String baseURL = "http://twitter.com/";
    private String searchBaseURL = "http://search.twitter.com/";
    private String source;
    private boolean usePostForcibly = false;
    private static final int MAX_COUNT = 200;
    private static final long serialVersionUID = -7550633067620779906L;
    static final String VERSION = "2.0.0";
    public static final Device IM = new Device("im");
    public static final Device SMS = new Device("sms");
    public static final Device NONE = new Device("none");
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Twitter() {
        this.http = new HttpClient();
        this.setUserAgent("twitter4j http://yusuke.homeip.net/twitter4j/ /2.0.0");
        this.setSource("Twitter4J");
        this.setClientVersion(VERSION);
        this.setClientURL("http://yusuke.homeip.net/twitter4j/en/twitter4j-2.0.0.xml");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.http.setRequestTokenURL("http://twitter.com/oauth/request_token");
        this.http.setAuthorizationURL("http://twitter.com/oauth/authorize");
        this.http.setAccessTokenURL("http://twitter.com/oauth/access_token");
        this.setUserId(null);
        this.setPassword(null);
    }

    public Twitter(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public Twitter(String id, String password) {
        this();
        this.setUserId(id);
        this.setPassword(password);
    }

    public Twitter(String id, String password, String baseURL) {
        this();
        this.setUserId(id);
        this.setPassword(password);
        this.baseURL = baseURL;
    }

    public void setUserAgent(String userAgent) {
        this.http.setUserAgent(System.getProperty("twitter4j.http.userAgent", userAgent));
    }

    public String getUserAgent() {
        return this.http.getUserAgent();
    }

    public void setClientVersion(String version) {
        this.setRequestHeader("X-Twitter-Client-Version", System.getProperty("twitter4j.clientVersion", version));
    }

    public String getClientVersion() {
        return this.http.getRequestHeader("X-Twitter-Client-Version");
    }

    public void setClientURL(String clientURL) {
        this.setRequestHeader("X-Twitter-Client-URL", System.getProperty("twitter4j.clientURL", clientURL));
    }

    public String getClientURL() {
        return this.http.getRequestHeader("X-Twitter-Client-URL");
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    public void setUserId(String userId) {
        this.http.setUserId(System.getProperty("twitter4j.user", userId));
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public void setPassword(String password) {
        this.http.setPassword(System.getProperty("twitter4j.password", password));
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.http.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.http.getOAuthRequestToken();
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.http.setOAuthAccessToken(accessToken);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    public void setHttpProxy(String proxyHost, int proxyPort) {
        this.http.setProxyHost(proxyHost);
        this.http.setProxyPort(proxyPort);
    }

    public void setHttpProxyAuth(String proxyUser, String proxyPass) {
        this.http.setProxyAuthUser(proxyUser);
        this.http.setProxyAuthPassword(proxyPass);
    }

    public void setHttpConnectionTimeout(int connectionTimeout) {
        this.http.setConnectionTimeout(connectionTimeout);
    }

    public void setHttpReadTimeout(int readTimeout) {
        this.http.setReadTimeout(readTimeout);
    }

    public void setSource(String source) {
        this.source = System.getProperty("twitter4j.source", source);
        this.setRequestHeader("X-Twitter-Client", this.source);
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public void forceUsePost(boolean forceUsePost) {
        this.usePostForcibly = forceUsePost;
    }

    public boolean isUsePostForced() {
        return this.usePostForcibly;
    }

    private Response get(String url, boolean authenticate) throws TwitterException {
        return this.get(url, null, authenticate);
    }

    protected Response get(String url, String name1, String value1, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1)}, authenticate);
    }

    protected Response get(String url, String name1, String value1, String name2, String value2, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)}, authenticate);
    }

    protected Response get(String url, PostParameter[] params, boolean authenticate) throws TwitterException {
        if (this.usePostForcibly) {
            if (null == params) {
                return this.http.post(url, new PostParameter[0], authenticate);
            }
            return this.http.post(url, params, authenticate);
        }
        if (null != params && params.length > 0) {
            url = new StringBuffer().append(url).append("?").append(HttpClient.encodeParameters(params)).toString();
        }
        return this.http.get(url, authenticate);
    }

    public synchronized List<Status> getPublicTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml").toString(), false).asDocument(), this);
    }

    public synchronized List<Status> getPublicTimeline(int sinceID) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml").toString(), "since_id", String.valueOf(sinceID), false).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimelineByPage(int page) throws TwitterException {
        return this.getFriendsTimeline(page);
    }

    public synchronized List<Status> getFriendsTimeline(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(long sinceId, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "since_id", String.valueOf(sinceId), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimelineByPage(String id, int page) throws TwitterException {
        return this.getFriendsTimeline(id, page);
    }

    public synchronized List<Status> getFriendsTimeline(String id, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(long sinceId, String id, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), "since_id", String.valueOf(sinceId), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "since", this.format.format(since), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), true).asDocument(), this);
    }

    public synchronized List<Status> getFriendsTimeline(String id, long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id, int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), "count", String.valueOf(count), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id, int count, long sinceId) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "since_id", String.valueOf(sinceId), "count", String.valueOf(count), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "since", this.format.format(since), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id, int count) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), "count", String.valueOf(count), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), "since", this.format.format(since), "count", String.valueOf(count), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(int count, long sinceId) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), "sinceId", String.valueOf(sinceId), "count", String.valueOf(count), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(String id, long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml?since_id=").append(sinceId).toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getUserTimeline(long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml?since_id=").append(sinceId).toString(), true).asDocument(), this);
    }

    public synchronized Status show(int id) throws TwitterException {
        return new Status(this.get(new StringBuffer().append(this.baseURL).append("statuses/show/").append(id).append(".xml").toString(), false).asDocument().getDocumentElement(), this);
    }

    public synchronized Status show(long id) throws TwitterException {
        return new Status(this.get(new StringBuffer().append(this.baseURL).append("statuses/show/").append(id).append(".xml").toString(), false).asDocument().getDocumentElement(), this);
    }

    public Status update(String status) throws TwitterException {
        if (status.length() > 160) {
            status = status.substring(0, 160);
        }
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/update.xml").toString(), new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, true).asDocument().getDocumentElement(), this);
    }

    public Status update(String status, long inReplyToStatusId) throws TwitterException {
        if (status.length() > 160) {
            status = status.substring(0, 160);
        }
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/update.xml").toString(), new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true).asDocument().getDocumentElement(), this);
    }

    public synchronized List<Status> getReplies() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<Status> getReplies(long sinceId) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<Status> getRepliesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getReplies(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> getReplies(long sinceId, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), "since_id", String.valueOf(sinceId), "page", String.valueOf(page), true).asDocument(), this);
    }

    public Status destroyStatus(long statusId) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/destroy/").append(statusId).append(".xml").toString(), new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public synchronized List<User> getFriends() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<User> getFriends(int page) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<User> getFriends(String id) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public synchronized List<User> getFriends(String id, int page) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/friends/").append(id).append(".xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<User> getFollowers() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<User> getFollowers(int page) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<User> getFollowers(String id) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public synchronized List<User> getFollowers(String id, int page) throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/followers/").append(id).append(".xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<User> getFeatured() throws TwitterException {
        return User.constructUsers(this.get(new StringBuffer().append(this.baseURL).append("statuses/featured.xml").toString(), true).asDocument(), this);
    }

    public synchronized ExtendedUser getUserDetail(String id) throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("users/show/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized List<DirectMessage> getDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getDirectMessagesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getDirectMessages(int page, int sinceId) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), "page", String.valueOf(page), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), "since", this.format.format(since), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getSentDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), new PostParameter[0], true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getSentDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), "since", this.format.format(since), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getSentDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized List<DirectMessage> getSentDirectMessages(int page, int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), "page", String.valueOf(page), "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public synchronized DirectMessage sendDirectMessage(String id, String text) throws TwitterException {
        if (text.length() > 160) {
            text = text.substring(0, 160);
        }
        return new DirectMessage(this.http.post(new StringBuffer().append(this.baseURL).append("direct_messages/new.xml").toString(), new PostParameter[]{new PostParameter("user", id), new PostParameter("text", text)}, true).asDocument().getDocumentElement(), this);
    }

    public synchronized DirectMessage deleteDirectMessage(int id) throws TwitterException {
        return new DirectMessage(this.http.post(new StringBuffer().append(this.baseURL).append("direct_messages/destroy/").append(id).append(".xml").toString(), new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public synchronized User create(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("friendships/create/").append(id).append(".xml").toString(), new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public synchronized User destroy(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("friendships/destroy/").append(id).append(".xml").toString(), new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public synchronized boolean exists(String user_a, String user_b) throws TwitterException {
        return this.get(new StringBuffer().append(this.baseURL).append("friendships/exists.xml").toString(), "user_a", user_a, "user_b", user_b, true).asString().contains("true");
    }

    public synchronized IDs getFriendsIDs() throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml").toString(), true).asDocument().getDocumentElement());
    }

    public synchronized IDs getFriendsIDs(int userId) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?user_id=").append(userId).toString(), true).asDocument().getDocumentElement());
    }

    public synchronized IDs getFriendsIDs(String screenName) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("friends/ids.xml?screen_name=").append(screenName).toString(), true).asDocument().getDocumentElement());
    }

    public synchronized IDs getFollowersIDs() throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml").toString(), true).asDocument().getDocumentElement());
    }

    public synchronized IDs getFollowersIDs(int userId) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?user_id=").append(userId).toString(), true).asDocument().getDocumentElement());
    }

    public synchronized IDs getFollowersIDs(String screenName) throws TwitterException {
        return new IDs(this.get(new StringBuffer().append(this.baseURL).append("followers/ids.xml?screen_name=").append(screenName).toString(), true).asDocument().getDocumentElement());
    }

    public synchronized ExtendedUser verifyCredentials() throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("account/verify_credentials.xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized User updateLocation(String location) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_location.xml").toString(), new PostParameter[]{new PostParameter("location", location)}, true).asDocument().getDocumentElement(), this);
    }

    public synchronized ExtendedUser updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        ArrayList<PostParameter> colors = new ArrayList<PostParameter>(5);
        this.addColor(colors, "profile_background_color", profileBackgroundColor);
        this.addColor(colors, "profile_text_color", profileTextColor);
        this.addColor(colors, "profile_link_color", profileLinkColor);
        this.addColor(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addColor(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        return new ExtendedUser(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_profile_colors.xml").toString(), colors.toArray(new PostParameter[colors.size()]), true).asDocument().getDocumentElement(), this);
    }

    private void addColor(List<PostParameter> colors, String paramName, String color) {
        if (null != color) {
            colors.add(new PostParameter(paramName, color));
        }
    }

    public synchronized RateLimitStatus rateLimitStatus() throws TwitterException {
        return new RateLimitStatus(this.http.get(new StringBuffer().append(this.baseURL).append("account/rate_limit_status.xml").toString(), null != this.getUserId() && null != this.getPassword()).asDocument().getDocumentElement());
    }

    public synchronized User updateDeliverlyDevice(Device device) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("account/update_delivery_device.xml").toString(), new PostParameter[]{new PostParameter("device", device.DEVICE)}, true).asDocument().getDocumentElement(), this);
    }

    public synchronized List<Status> favorites() throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites.xml").toString(), new PostParameter[0], true).asDocument(), this);
    }

    public synchronized List<Status> favorites(int page) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites.xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized List<Status> favorites(String id) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml").toString(), new PostParameter[0], true).asDocument(), this);
    }

    public synchronized List<Status> favorites(String id, int page) throws TwitterException {
        return Status.constructStatuses(this.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml").toString(), "page", String.valueOf(page), true).asDocument(), this);
    }

    public synchronized Status createFavorite(long id) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("favorites/create/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized Status destroyFavorite(long id) throws TwitterException {
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("favorites/destroy/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized User follow(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("notifications/follow/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized User leave(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("notifications/leave/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized User block(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/create/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized User unblock(String id) throws TwitterException {
        return new User(this.http.post(new StringBuffer().append(this.baseURL).append("blocks/destroy/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized boolean test() throws TwitterException {
        return -1 != this.get(new StringBuffer().append(this.baseURL).append("help/test.xml").toString(), false).asString().indexOf("ok");
    }

    public synchronized ExtendedUser getAuthenticatedUser() throws TwitterException {
        return new ExtendedUser(this.get(new StringBuffer().append(this.baseURL).append("account/verify_credentials.xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public synchronized String getDowntimeSchedule() throws TwitterException {
        return this.get(new StringBuffer().append(this.baseURL).append("help/downtime_schedule.xml").toString(), false).asString();
    }

    public synchronized QueryResult search(Query query) throws TwitterException {
        return new QueryResult(this.get(new StringBuffer().append(this.searchBaseURL).append("search.json").toString(), query.asPostParameters(), false).asJSONObject(), this);
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Twitter twitter = (Twitter)o;
        if (this.usePostForcibly != twitter.usePostForcibly) {
            return false;
        }
        if (!this.baseURL.equals(twitter.baseURL)) {
            return false;
        }
        if (!this.format.equals(twitter.format)) {
            return false;
        }
        if (!this.http.equals(twitter.http)) {
            return false;
        }
        if (!this.searchBaseURL.equals(twitter.searchBaseURL)) {
            return false;
        }
        return this.source.equals(twitter.source);
    }

    public int hashCode() {
        int result = this.http.hashCode();
        result = 31 * result + this.baseURL.hashCode();
        result = 31 * result + this.searchBaseURL.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (this.usePostForcibly ? 1 : 0);
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        return new StringBuffer().append("Twitter{http=").append(this.http).append(", baseURL='").append(this.baseURL).append('\'').append(", searchBaseURL='").append(this.searchBaseURL).append('\'').append(", source='").append(this.source).append('\'').append(", usePostForcibly=").append(this.usePostForcibly).append(", format=").append(this.format).append('}').toString();
    }

    static class Device {
        final String DEVICE;

        public Device(String device) {
            this.DEVICE = device;
        }
    }
}

