/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import twitter4j.TwitterException;
import twitter4j.http.BASE64Encoder;
import twitter4j.http.PostParameter;
import twitter4j.http.Response;

public class HttpClient
implements Serializable {
    private final int OK = 200;
    private final int NOT_MODIFIED = 304;
    private final int UNAUTHORIZED = 401;
    private final int FORBIDDEN = 403;
    private final boolean DEBUG = Boolean.getBoolean("twitter4j.debug");
    private final int INTERNAL_SERVER_ERROR = 500;
    private String basic = null;
    private int retryCount = 0;
    private int retryIntervalMillis = 10000;
    private String userId = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyAuthUser = null;
    private String proxyAuthPassword = null;
    private int connectionTimeout = 0;
    private int readTimeout = 0;
    private static final long serialVersionUID = 808018030183407996L;
    private boolean isJDK14orEarlier = false;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    int retriedCount = 0;
    String lastURL;

    public HttpClient(String userId, String password) {
        this();
        this.setUserId(userId);
        this.setPassword(password);
    }

    public HttpClient() {
        this.setProxyPort(0);
        this.setProxyHost(null);
        this.setConnectionTimeout(10000);
        this.setReadTimeout(30000);
        this.setProxyAuthUser(null);
        this.setProxyAuthPassword(null);
        String versionStr = System.getProperty("java.specification.version");
        if (null != versionStr) {
            this.isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
        }
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.encodeBasicAuthenticationString();
    }

    public void setPassword(String password) {
        this.password = password;
        this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = System.getProperty("twitter4j.http.proxyHost", System.getProperty("http.proxyHost", proxyHost));
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        try {
            this.proxyPort = Integer.parseInt(System.getProperty("twitter4j.http.proxyPort", System.getProperty("http.proxyPort", String.valueOf(proxyPort))));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = System.getProperty("twitter4j.http.proxyUser", proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = System.getProperty("twitter4j.http.proxyPassword", proxyAuthPassword);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        try {
            this.connectionTimeout = Integer.parseInt(System.getProperty("twitter4j.http.connectionTimeout", String.valueOf(connectionTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        try {
            this.readTimeout = Integer.parseInt(System.getProperty("twitter4j.http.readTimeout", String.valueOf(readTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void encodeBasicAuthenticationString() {
        if (null != this.userId && null != this.password) {
            this.basic = "Basic " + new String(new BASE64Encoder().encode((this.userId + ":" + this.password).getBytes()));
        }
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = retryCount;
    }

    public void setUserAgent(String ua) {
        this.setRequestHeader("User-Agent", ua);
    }

    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        if (retryIntervalSecs < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalMillis = retryIntervalSecs * 1000;
    }

    public Response post(String url, PostParameter[] PostParameters, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, PostParameters, authenticated);
    }

    public Response post(String url, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, new PostParameter[0], authenticated);
    }

    public Response post(String url, PostParameter[] PostParameters) throws TwitterException {
        return this.httpRequest(url, PostParameters, false);
    }

    public Response post(String url) throws TwitterException {
        return this.httpRequest(url, new PostParameter[0], false);
    }

    public Response get(String url, boolean authenticated) throws TwitterException {
        return this.httpRequest(url, null, authenticated);
    }

    public Response get(String url) throws TwitterException {
        return this.httpRequest(url, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response httpRequest(String url, PostParameter[] postParams, boolean authenticated) throws TwitterException {
        int retry = this.retryCount + 1;
        Response res = null;
        this.lastURL = url;
        this.retriedCount = 0;
        while (this.retriedCount < retry) {
            int responseCode = -1;
            try {
                HttpURLConnection con = null;
                InputStream is = null;
                OutputStream osw = null;
                try {
                    con = this.getConnection(url);
                    con.setDoInput(true);
                    this.setHeaders(con, authenticated);
                    if (null != postParams) {
                        this.log("POST ", url);
                        con.setRequestMethod("POST");
                        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        con.setDoOutput(true);
                        String postParam = HttpClient.encodeParameters(postParams);
                        this.log("Post Params: ", postParam);
                        byte[] bytes = postParam.getBytes("UTF-8");
                        con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                        osw = con.getOutputStream();
                        osw.write(bytes);
                        osw.flush();
                        osw.close();
                    } else {
                        this.log("GET " + url);
                        con.setRequestMethod("GET");
                    }
                    responseCode = con.getResponseCode();
                    this.log("Response code: ", String.valueOf(responseCode));
                    is = responseCode == 401 || responseCode == 403 ? con.getErrorStream() : con.getInputStream();
                    res = new Response(con.getResponseCode(), is);
                    this.log("Response: ", res.toString());
                    if (responseCode == 401 || responseCode == 403) {
                        throw new TwitterException(res.toString(), responseCode);
                    }
                    break;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ignore) {}
                    try {
                        osw.close();
                    }
                    catch (Exception ignore) {}
                    try {
                        con.disconnect();
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (IOException ioe) {
                if (responseCode == 401 || responseCode == 403) {
                    if (this.DEBUG) {
                        ioe.printStackTrace();
                    }
                    throw new TwitterException(ioe.getMessage(), responseCode);
                }
                if (this.retriedCount == this.retryCount) {
                    throw new TwitterException(ioe.getMessage(), responseCode);
                }
                try {
                    Thread.sleep(this.retryIntervalMillis);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                ++this.retriedCount;
            }
        }
        return res;
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < postParams.length; ++j) {
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(postParams[j].name).append("=").append(URLEncoder.encode(postParams[j].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    private void setHeaders(HttpURLConnection connection, boolean authenticated) {
        if (authenticated) {
            if (this.basic == null) {
                throw new IllegalStateException("user ID/password combination not supplied");
            }
            connection.addRequestProperty("Authorization", this.basic);
        }
        Iterator<String> i$ = this.requestHeaders.keySet().iterator();
        while (i$.hasNext()) {
            String key = i$.next();
            connection.addRequestProperty(key, this.requestHeaders.get(key));
        }
    }

    public void setRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con = null;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                this.log("Proxy AuthUser: " + this.proxyAuthUser);
                this.log("Proxy AuthPassword: " + this.proxyAuthPassword);
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.proxyAuthUser, HttpClient.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (this.DEBUG) {
                this.log("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.connectionTimeout > 0 && !this.isJDK14orEarlier) {
            con.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !this.isJDK14orEarlier) {
            con.setReadTimeout(this.readTimeout);
        }
        return con;
    }

    public int hashCode() {
        return this.retryCount + this.retryIntervalMillis + this.basic.hashCode() + ((Object)this.requestHeaders).hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpClient) {
            HttpClient that = (HttpClient)obj;
            return this.retryCount == that.retriedCount && this.retryIntervalMillis == that.retryIntervalMillis && this.basic.equals(that.basic) && ((Object)this.requestHeaders).equals(that.requestHeaders);
        }
        return false;
    }

    private void log(String message) {
        if (this.DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private void log(String message, String message2) {
        if (this.DEBUG) {
            this.log(message + message2);
        }
    }
}

