/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends TwitterResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Status(Element elem, Twitter twitter) throws TwitterException {
        this.ensureRootNodeNameIs("status", elem);
        this.user = new User((Element)elem.getElementsByTagName("user").item(0), twitter);
        this.id = this.getChildLong("id", elem);
        this.text = this.getChildText("text", elem);
        this.source = this.getChildText("source", elem);
        this.createdAt = this.getChildDate("created_at", elem);
        this.isTruncated = this.getChildBoolean("truncated", elem);
        this.inReplyToStatusId = this.getChildInt("in_reply_to_status_id", elem);
        this.inReplyToUserId = this.getChildInt("in_reply_to_user_id", elem);
        this.isFavorited = this.getChildBoolean("favorited", elem);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    static List<Status> constructStatuses(Document doc, Twitter twitter) throws TwitterException {
        if (Status.isRootNodeNilClasses(doc)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(status, twitter));
            }
            return statuses;
        }
        catch (TwitterException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Status>(0);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).id == this.id;
    }

    public String toString() {
        return "Status{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", user=" + this.user + '}';
    }
}

