/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import org.w3c.dom.Element;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class UserWithStatus
extends User {
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private int followersCount;
    private int favouritesCount;
    private int statusesCount;
    private Date createdAt;
    private String text;
    private long statusId;
    private static final long serialVersionUID = -1186848883283901709L;

    public UserWithStatus(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.profileBackgroundColor = this.getChildText("profile_background_color", elem);
        this.profileTextColor = this.getChildText("profile_text_color", elem);
        this.profileLinkColor = this.getChildText("profile_link_color", elem);
        this.profileSidebarFillColor = this.getChildText("profile_sidebar_fill_color", elem);
        this.profileSidebarBorderColor = this.getChildText("profile_sidebar_border_color", elem);
        this.friendsCount = this.getChildInt("friends_count", elem);
        this.followersCount = this.getChildInt("followers_count", elem);
        this.favouritesCount = this.getChildInt("favourites_count", elem);
        this.statusesCount = this.getChildInt("statuses_count", elem);
        this.createdAt = this.getChildDate("created_at", elem);
        this.text = this.getChildText("text", elem);
        this.statusId = Long.valueOf(((Element)elem.getElementsByTagName("status").item(0)).getElementsByTagName("id").item(0).getTextContent());
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public Date getStatusCreatedAt() {
        return this.createdAt;
    }

    public long getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.text;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId() == this.getId();
    }

    public String toString() {
        return "UserWithStatus{profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", followersCount=" + this.followersCount + ", favouritesCount=" + this.favouritesCount + ", statusesCount=" + this.statusesCount + ", createdAt=" + this.createdAt + ", text='" + this.text + '\'' + ", statusId=" + this.statusId + '}';
    }
}

