/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserWithStatus;
import twitter4j.http.HttpClient;
import twitter4j.http.PostParameter;
import twitter4j.http.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
implements Serializable {
    HttpClient http = null;
    private String baseURL = "http://twitter.com/";
    private String source = "Twitter4J";
    private boolean usePostForcibly = false;
    private static final long serialVersionUID = 4346156413282535531L;
    private static final int MAX_COUNT = 200;
    public static final Device IM = new Device("im");
    public static final Device SMS = new Device("sms");
    public static final Device NONE = new Device("none");
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Twitter() {
        this.http = new HttpClient();
        this.setRequestHeader("X-Twitter-Client", "Twitter4J");
        this.setRequestHeader("X-Twitter-Client-Version", "1.1.0");
        this.setRequestHeader("X-Twitter-Client-URL", "http://yusuke.homeip.net/twitter4j/en/twitter4j-1.1.0.xml");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Twitter(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public Twitter(String id, String password) {
        this();
        this.setUserId(id);
        this.setPassword(password);
    }

    public Twitter(String id, String password, String baseURL) {
        this(id, password);
        this.baseURL = baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setUserId(String userId) {
        this.http.setUserId(userId);
    }

    public String getUserId() {
        return this.http.getUserId();
    }

    public void setPassword(String password) {
        this.http.setPassword(password);
    }

    public String getPassword() {
        return this.http.getPassword();
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public void forceUsePost(boolean forceUsePost) {
        this.usePostForcibly = forceUsePost;
    }

    public boolean isUsePostForced() {
        return this.usePostForcibly;
    }

    private Response get(String url, boolean authenticate) throws TwitterException {
        return this.get(url, null, authenticate);
    }

    private Response get(String url, String name1, String value1, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1)}, authenticate);
    }

    private Response get(String url, String name1, String value1, String name2, String value2, boolean authenticate) throws TwitterException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)}, authenticate);
    }

    private Response get(String url, PostParameter[] params, boolean authenticate) throws TwitterException {
        if (this.usePostForcibly) {
            if (null == params) {
                return this.http.post(url, new PostParameter[0], authenticate);
            }
            return this.http.post(url, params, authenticate);
        }
        if (null != params && params.length > 0) {
            url = url + "?" + HttpClient.encodeParameters(params);
        }
        return this.http.get(url, authenticate);
    }

    public final synchronized List<Status> getPublicTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/public_timeline.xml", false).asDocument(), this);
    }

    public final synchronized List<Status> getPublicTimeline(int sinceID) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/public_timeline.xml", "since_id", String.valueOf(sinceID), false).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline.xml", true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimelineByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline/" + id + ".xml", true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimelineByPage(String id, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline/" + id + ".xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(Date since) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline.xml", "since", this.formatDate(since), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/friends_timeline/" + id + ".xml", "since", this.formatDate(since), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline/" + id + ".xml", "since", this.formatDate(since), "count", String.valueOf(count), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline/" + id + ".xml", "since", this.formatDate(since), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, int count) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline/" + id + ".xml", "count", String.valueOf(count), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(int count, Date since) throws TwitterException {
        if (200 < count) {
            throw new IllegalArgumentException("count may not be greater than 200 for performance purposes.");
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline.xml", "since", this.formatDate(since), "count", String.valueOf(count), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline/" + id + ".xml", true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline() throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/user_timeline.xml", true).asDocument(), this);
    }

    public final synchronized Status show(int id) throws TwitterException {
        return new Status(this.get(this.baseURL + "statuses/show/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public Status update(String status) throws TwitterException {
        if (status.length() > 160) {
            status = status.substring(0, 160);
        }
        return new Status(this.http.post(this.baseURL + "statuses/update.xml", new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<Status> getReplies() throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "statuses/replies.xml", true).asDocument(), this);
    }

    public final synchronized List<Status> getRepliesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return Status.constructStatuses(this.get(this.baseURL + "statuses/replies.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public Status destroyStatus(long statusId) throws TwitterException {
        return new Status(this.http.post(this.baseURL + "statuses/destroy/" + statusId + ".xml", new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<User> getFriends() throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/friends.xml", true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(int page) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/friends.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(String id) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/friends.xml", "id", id, true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(String id, int page) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/friends.xml", "id", id, "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<User> getFollowers() throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/followers.xml", true).asDocument(), this);
    }

    public final synchronized List<User> getFollowers(int page) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/followers.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<User> getFollowers(String id) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/followers/" + id + ".xml", true).asDocument(), this);
    }

    public final synchronized List<User> getFollowers(String id, int page) throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/followers/" + id + ".xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<User> getFeatured() throws TwitterException {
        return User.constructUsers(this.get(this.baseURL + "statuses/featured.xml", true).asDocument(), this);
    }

    public final synchronized UserWithStatus getUserDetail(String id) throws TwitterException {
        return new UserWithStatus(this.get(this.baseURL + "users/show/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages.xml", true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessagesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages.xml", "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages.xml", "since", this.formatDate(since), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages/sent.xml", new PostParameter[0], true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages/sent.xml", "since", this.formatDate(since), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.get(this.baseURL + "direct_messages/sent.xml", "since_id", String.valueOf(sinceId), true).asDocument(), this);
    }

    public final synchronized DirectMessage sendDirectMessage(String id, String text) throws TwitterException {
        if (text.length() > 160) {
            text = text.substring(0, 160);
        }
        return new DirectMessage(this.http.post(this.baseURL + "direct_messages/new.xml", new PostParameter[]{new PostParameter("user", id), new PostParameter("text", text)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized DirectMessage deleteDirectMessage(int id) throws TwitterException {
        return new DirectMessage(this.http.post(this.baseURL + "direct_messages/destroy/" + id + ".xml", new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User create(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "friendships/create/" + id + ".xml", new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User destroy(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "friendships/destroy/" + id + ".xml", new PostParameter[0], true).asDocument().getDocumentElement(), this);
    }

    public final synchronized boolean verifyCredentials() {
        try {
            return this.get(this.baseURL + "account/verify_credentials.xml", true).asString().contains("true");
        }
        catch (TwitterException te) {
            return false;
        }
    }

    public final synchronized User updateLocation(String location) throws TwitterException {
        return new User(this.http.post(this.baseURL + "account/update_location.xml", new PostParameter[]{new PostParameter("location", location)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User updateDeliverlyDevice(Device device) throws TwitterException {
        return new User(this.http.post(this.baseURL + "account/update_delivery_device", new PostParameter[]{new PostParameter("device", device.DEVICE)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<Status> favorites() throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "favorites.xml", new PostParameter[0], true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(int page) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "favorites.xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(String id) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "favorites/" + id + ".xml", new PostParameter[0], true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(String id, int page) throws TwitterException {
        return Status.constructStatuses(this.get(this.baseURL + "favorites/" + id + ".xml", "page", String.valueOf(page), true).asDocument(), this);
    }

    public final synchronized Status createFavorite(long id) throws TwitterException {
        return new Status(this.http.post(this.baseURL + "favorites/create/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized Status destroyFavorite(long id) throws TwitterException {
        return new Status(this.http.post(this.baseURL + "favorites/destroy/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User follow(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "notifications/follow/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User leave(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "notifications/leave/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User block(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "blocks/create/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User unblock(String id) throws TwitterException {
        return new User(this.http.post(this.baseURL + "blocks/destroy/" + id + ".xml", true).asDocument().getDocumentElement(), this);
    }

    public final synchronized boolean test() throws TwitterException {
        return -1 != this.get(this.baseURL + "help/test.xml", false).asString().indexOf("ok");
    }

    public final synchronized String getDowntimeSchedule() throws TwitterException {
        return this.get(this.baseURL + "help/downtime_schedule.xml", false).asString();
    }

    private String formatDate(Date date) {
        try {
            return URLEncoder.encode(this.format.format(date), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return URLEncoder.encode(this.format.format(date));
        }
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }

    public int hashCode() {
        return this.http.hashCode() + this.baseURL.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Twitter) {
            Twitter that = (Twitter)obj;
            return this.http.equals(that.http) && this.baseURL.equals(that.baseURL);
        }
        return false;
    }

    static class Device {
        final String DEVICE;

        public Device(String device) {
            this.DEVICE = device;
        }
    }
}

