/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
extends TwitterResponse
implements Serializable {
    private int id;
    private String text;
    private int sender_id;
    private int recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessage(Element elem, Twitter twitter) throws TwitterException {
        this.ensureRootNodeNameIs("direct_message", elem);
        this.sender = new User((Element)elem.getElementsByTagName("sender").item(0), twitter);
        this.recipient = new User((Element)elem.getElementsByTagName("recipient").item(0), twitter);
        this.id = this.getChildInt("id", elem);
        this.text = this.getChildText("text", elem);
        this.sender_id = this.getChildInt("sender_id", elem);
        this.recipient_id = this.getChildInt("recipient_id", elem);
        this.created_at = this.getChildDate("created_at", elem);
        this.sender_screen_name = this.getChildText("sender_screen_name", elem);
        this.recipient_screen_name = this.getChildText("recipient_screen_name", elem);
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getSenderId() {
        return this.sender_id;
    }

    public int getRecipientId() {
        return this.recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Document doc, Twitter twitter) throws TwitterException {
        if (DirectMessage.isRootNodeNilClasses(doc)) {
            return new ArrayList<DirectMessage>(0);
        }
        try {
            DirectMessage.ensureRootNodeNameIs("direct-messages", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("direct_message");
            int size = list.getLength();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                messages.add(new DirectMessage(status, twitter));
            }
            return messages;
        }
        catch (TwitterException te) {
            if (DirectMessage.isRootNodeNilClasses(doc)) {
                return new ArrayList<DirectMessage>(0);
            }
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DirectMessage) {
            return ((DirectMessage)obj).id == this.id;
        }
        return false;
    }
}

