/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class TwitterResponse
implements Serializable {
    protected final Element elem;
    protected Twitter twitter;
    private static final long serialVersionUID = 351190117061895609L;

    public TwitterResponse(Element elem, Twitter twitter) {
        this.elem = elem;
        this.twitter = twitter;
    }

    protected void ensureRootNodeNameIs(String rootName) throws TwitterException {
        if (!rootName.equals(this.elem.getNodeName())) {
            throw new TwitterException("Unexpected root node name:" + this.elem.getNodeName() + ". Expected:" + rootName + ". Check Twitter service availability.\n" + TwitterResponse.toString(this.elem));
        }
    }

    protected void ensureRootNodeNameIs(String[] rootNames) throws TwitterException {
        String actualRootName = this.elem.getNodeName();
        for (String rootName : rootNames) {
            if (!rootName.equals(actualRootName)) continue;
            return;
        }
        String expected = "";
        for (int i = 0; i < rootNames.length; ++i) {
            if (i != 0) {
                expected = expected + " or ";
            }
            expected = expected + rootNames[i];
        }
        throw new TwitterException("Unexpected root node name:" + this.elem.getNodeName() + ". Expected:" + expected + ". Check Twitter service availability.\n" + TwitterResponse.toString(this.elem));
    }

    protected static void ensureRootNodeNameIs(String rootName, Element elem) throws TwitterException {
        if (!rootName.equals(elem.getNodeName())) {
            throw new TwitterException("Unexpected root node name:" + elem.getNodeName() + ". Expected:" + rootName + ". Check Twitter service availability.\n" + TwitterResponse.toString(elem));
        }
    }

    private static String toString(Element doc) {
        try {
            StringWriter output = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerException tfe) {
            return "";
        }
    }

    protected String getChildText(String str) {
        return this.elem.getElementsByTagName(str).item(0).getTextContent();
    }

    protected int getChildInt(String str) {
        String str2 = this.elem.getElementsByTagName(str).item(0).getTextContent();
        if (null == str2 || "".equals(str2)) {
            return -1;
        }
        return Integer.valueOf(str2);
    }

    protected boolean getChildBoolean(String str) {
        return Boolean.valueOf(this.elem.getElementsByTagName(str).item(0).getTextContent());
    }

    public int hashCode() {
        return this.elem.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TwitterResponse) {
            ((TwitterResponse)obj).elem.equals(this.elem);
        }
        return false;
    }
}

