/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.LinkedList;
import java.util.Queue;
import twitter4j.ExecuteThread;

class Dispatcher {
    private ExecuteThread[] threads;
    private Queue<Runnable> q = new LinkedList<Runnable>();
    Object ticket = new Object();
    private boolean active = true;

    public Dispatcher(String name) {
        this(name, 1);
    }

    public Dispatcher(String name, int threadcount) {
        this.threads = new ExecuteThread[threadcount];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ExecuteThread(name, this, i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Dispatcher.this.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeLater(Runnable task) {
        Object object = this.q;
        synchronized (object) {
            this.q.add(task);
        }
        object = this.ticket;
        synchronized (object) {
            this.ticket.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        while (true) {
            Object object = this.q;
            synchronized (object) {
                Runnable task = this.q.poll();
                if (null != task) {
                    return task;
                }
            }
            object = this.ticket;
            synchronized (object) {
                try {
                    this.ticket.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.active) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].shutdown();
            }
            Queue<Runnable> queue = this.q;
            synchronized (queue) {
                this.q.notify();
            }
        } else {
            throw new IllegalStateException("Already shutdown");
        }
    }
}

