/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.DirectMessage;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends TwitterResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient"};

    User(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.ensureRootNodeNameIs(POSSIBLE_ROOT_NAMES);
    }

    public int getId() {
        return this.getChildInt("id");
    }

    public String getName() {
        return this.getChildText("name");
    }

    public String getScreenName() {
        return this.getChildText("screen_name");
    }

    public String getLocation() {
        return this.getChildText("location");
    }

    public String getDescription() {
        return this.getChildText("description");
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.getChildText("profile_image_url"));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.getChildText("url"));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isProtected() {
        return "true".equalsIgnoreCase(this.getChildText("protected"));
    }

    public DirectMessage sendDirectMessage(String text) throws TwitterException {
        return this.twitter.sendDirectMessage(this.getName(), text);
    }

    public static List<User> constructUsers(Document doc, Twitter twitter) throws TwitterException {
        if (null == doc) {
            return new ArrayList<User>(0);
        }
        try {
            User.ensureRootNodeNameIs("users", doc.getDocumentElement());
            NodeList list = doc.getDocumentElement().getElementsByTagName("user");
            int size = list.getLength();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User((Element)list.item(i), twitter));
            }
            return users;
        }
        catch (TwitterException te) {
            User.ensureRootNodeNameIs("nil-classes", doc.getDocumentElement());
            return new ArrayList<User>(0);
        }
    }

    @Override
    public int hashCode() {
        return this.elem.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof User) {
            ((User)obj).elem.equals(this.elem);
        }
        return false;
    }
}

