/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserWithStatus;
import twitter4j.http.HttpClient;
import twitter4j.http.PostParameter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
implements Serializable {
    HttpClient http = null;
    private String baseURL = "http://twitter.com/";
    private String source;
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Twitter() {
        this.http = new HttpClient();
        this.setRequestHeader("X-Twitter-Client", "Twitter4J");
        this.setRequestHeader("X-Twitter-Client-Version", "1.0.3");
        this.setRequestHeader("X-Twitter-Client-URL", "http://yusuke.homeip.net/twitter4j/en/twitter4j-1.0.3.xml");
        this.source = "Twitter4J";
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Twitter(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public Twitter(String id, String password) {
        this.http = new HttpClient(id, password);
        this.http.setRequestHeader("X-Twitter-Client", "Twitter4J");
        this.http.setRequestHeader("X-Twitter-Client-Version", "1.0.3");
        this.http.setRequestHeader("X-Twitter-Client-URL", "http://yusuke.homeip.net/twitter4j/en/twitter4j-1.0.3.xml");
        this.source = "Twitter4J";
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Twitter(String id, String password, String baseURL) {
        this(id, password);
        this.baseURL = baseURL;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setRequestHeader(String name, String value) {
        this.http.setRequestHeader(name, value);
    }

    public final synchronized List<Status> getPublicTimeline() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml").toString(), false).asDocument(), this);
    }

    public final synchronized List<Status> getPublicTimeline(String sinceID) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml?since_id=").append(sinceID).toString(), false).asDocument(), this);
    }

    public final synchronized List<Status> getPublicTimeline(int sinceID) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/public_timeline.xml?since_id=").append(sinceID).toString(), false).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimelineByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimelineByPage(String id, int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(Date since) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline.xml?since=").append(this.formatDate(since)).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getFriendsTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends_timeline/").append(id).append(".xml?since=").append(this.formatDate(since)).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, int count, Date since) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml?since=").append(this.formatDate(since)).append("&count=").append(count).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, Date since) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml?since=").append(this.formatDate(since)).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id, int count) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml?count=").append(count).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(int count, Date since) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml?since=").append(this.formatDate(since)).append("&count=").append(count).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline(String id) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getUserTimeline() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/user_timeline.xml").toString(), true).asDocument(), this);
    }

    public final synchronized Status show(int id) throws TwitterException {
        return new Status(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/show/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public Status update(String status) throws TwitterException {
        if (status.length() > 160) {
            status = status.substring(0, 160);
        }
        return new Status(this.http.post(new StringBuffer().append(this.baseURL).append("statuses/update.xml").toString(), new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<Status> getReplies() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> getRepliesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/replies.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFriends() throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(int page) throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(String id) throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml?id=").append(id).toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFriends(String id, int page) throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/friends.xml?id=").append(id).append("&page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFollowers() throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/followers.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<User> getFeatured() throws TwitterException {
        return User.constructUsers(this.http.get(new StringBuffer().append(this.baseURL).append("statuses/featured.xml").toString(), true).asDocument(), this);
    }

    public final synchronized UserWithStatus getUserDetail(String id) throws TwitterException {
        return new UserWithStatus(this.http.get(new StringBuffer().append(this.baseURL).append("users/show/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessagesByPage(int page) throws TwitterException {
        if (page < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("page should be positive integer. passed:").append(page).toString());
        }
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml?since=").append(sinceId).toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages.xml?since=").append(this.formatDate(since)).toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages() throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages(Date since) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml?since=").append(this.formatDate(since)).toString(), true).asDocument(), this);
    }

    public final synchronized List<DirectMessage> getSentDirectMessages(int sinceId) throws TwitterException {
        return DirectMessage.constructDirectMessages(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages/sent.xml?since_id=").append(sinceId).toString(), true).asDocument(), this);
    }

    public final synchronized DirectMessage sendDirectMessage(String id, String text) throws TwitterException {
        if (text.length() > 160) {
            text = text.substring(0, 160);
        }
        return new DirectMessage(this.http.post(new StringBuffer().append(this.baseURL).append("direct_messages/new.xml").toString(), new PostParameter[]{new PostParameter("user", id), new PostParameter("text", text)}, true).asDocument().getDocumentElement(), this);
    }

    public final synchronized DirectMessage deleteDirectMessage(int id) throws TwitterException {
        return new DirectMessage(this.http.get(new StringBuffer().append(this.baseURL).append("direct_messages/destroy/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User create(String id) throws TwitterException {
        return new User(this.http.get(new StringBuffer().append(this.baseURL).append("friendships/create/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User destroy(String id) throws TwitterException {
        return new User(this.http.get(new StringBuffer().append(this.baseURL).append("friendships/destroy/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized boolean verifyCredentials() {
        try {
            return this.http.get(new StringBuffer().append(this.baseURL).append("account/verify_credentials.xml").toString(), true).asString().contains("true");
        }
        catch (TwitterException te) {
            return false;
        }
    }

    public final synchronized List<Status> archive() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("account/archive.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> archive(int page) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("account/archive.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> favorites() throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("favorites.xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(int page) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("favorites.xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(String id) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml").toString(), true).asDocument(), this);
    }

    public final synchronized List<Status> favorites(String id, int page) throws TwitterException {
        return Status.constructStatuses(this.http.get(new StringBuffer().append(this.baseURL).append("favorites/").append(id).append(".xml?page=").append(page).toString(), true).asDocument(), this);
    }

    public final synchronized Status createFavorite(int id) throws TwitterException {
        return new Status(this.http.get(new StringBuffer().append(this.baseURL).append("favorites/create/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized Status destroyFavorite(int id) throws TwitterException {
        return new Status(this.http.get(new StringBuffer().append(this.baseURL).append("favorites/destroy/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User follow(String id) throws TwitterException {
        return new User(this.http.get(new StringBuffer().append(this.baseURL).append("notifications/follow/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    public final synchronized User leave(String id) throws TwitterException {
        return new User(this.http.get(new StringBuffer().append(this.baseURL).append("notifications/leave/").append(id).append(".xml").toString(), true).asDocument().getDocumentElement(), this);
    }

    private String formatDate(Date date) {
        try {
            return URLEncoder.encode(this.format.format(date), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return URLEncoder.encode(this.format.format(date));
        }
    }

    public void setRetryCount(int retryCount) {
        this.http.setRetryCount(retryCount);
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        this.http.setRetryIntervalSecs(retryIntervalSecs);
    }

    public int hashCode() {
        return this.http.hashCode() + this.baseURL.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Twitter) {
            Twitter that = (Twitter)obj;
            return this.http.equals(that.http) && this.baseURL.equals(that.baseURL);
        }
        return false;
    }
}

