/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends TwitterResponse
implements Serializable {
    private User user = null;

    Status(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.ensureRootNodeNameIs("status");
        this.user = new User((Element)elem.getElementsByTagName("user").item(0), twitter);
    }

    public String getCreatedAt() {
        return this.getChildText("created_at");
    }

    public int getId() {
        return this.getChildInt("id");
    }

    public String getText() {
        return this.getChildText("text");
    }

    public User getUser() {
        return this.user;
    }

    static List<Status> constructStatuses(Document doc, Twitter twitter) throws TwitterException {
        if (null == doc) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc.getDocumentElement());
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(status, twitter));
            }
            return statuses;
        }
        catch (TwitterException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc.getDocumentElement());
            return new ArrayList<Status>(0);
        }
    }

    @Override
    public int hashCode() {
        return this.elem.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Status) {
            ((Status)obj).elem.equals(this.elem);
        }
        return false;
    }
}

